/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.collection;

import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.util.CoreXMLUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ChildListEntryDefinitionParser
extends ChildDefinitionParser {
    public static final String VALUE = "value";
    private boolean fromText = true;

    public ChildListEntryDefinitionParser(String propertyName) {
        super(propertyName, ListEntry.class);
        this.setIgnoredDefault(true);
    }

    public ChildListEntryDefinitionParser(String propertyName, String attributeName) {
        this(propertyName);
        this.addAlias(attributeName, VALUE);
        this.removeIgnored(attributeName);
        this.fromText = false;
    }

    protected void postProcess(BeanAssembler assembler, Element element) {
        if (this.fromText) {
            assembler.extendBean(VALUE, CoreXMLUtils.getTextChild(element), false);
        }
        super.postProcess(assembler, element);
    }

    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.parseChild(element, parserContext, builder);
    }

    public static class ListEntry {
        private Object value;

        public ListEntry() {
        }

        public ListEntry(Object proxied) {
            this();
            this.value = proxied;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

