/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers;

import org.mule.config.spring.parsers.AbstractMuleBeanDefinitionParser;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.assembly.PropertyConfiguration;
import org.mule.config.spring.parsers.assembly.ReusablePropertyConfiguration;
import org.mule.config.spring.parsers.assembly.TempWrapperPropertyConfiguration;
import org.mule.util.CoreXMLUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;

public abstract class AbstractHierarchicalDefinitionParser
extends AbstractMuleBeanDefinitionParser {
    private ReusablePropertyConfiguration targetPropertyConfiguration;
    private BeanDefinition forcedParent;

    public AbstractHierarchicalDefinitionParser() {
        this.targetPropertyConfiguration = new ReusablePropertyConfiguration(new TempWrapperPropertyConfiguration(this.beanPropertyConfiguration, false));
        this.forcedParent = null;
    }

    public PropertyConfiguration getTargetPropertyConfiguration() {
        return this.targetPropertyConfiguration;
    }

    protected String getParentBeanName(Element element) {
        return ((Element)element.getParentNode()).getAttribute("name");
    }

    public BeanDefinition getParentBeanDefinition(Element element) {
        if (null != this.forcedParent) {
            return this.forcedParent;
        }
        String parentBean = this.getParentBeanName(element);
        if (StringUtils.isBlank((String)parentBean)) {
            throw new IllegalStateException("No parent for " + CoreXMLUtils.elementToString(element));
        }
        return this.getRegistry().getBeanDefinition(parentBean);
    }

    protected BeanAssembler getBeanAssembler(Element element, BeanDefinitionBuilder bean) {
        BeanDefinition target = this.getParentBeanDefinition(element);
        return this.getBeanAssemblerFactory().newBeanAssembler(this.beanPropertyConfiguration, bean, this.targetPropertyConfiguration, target);
    }

    protected BeanAssembler getOrphanBeanAssembler(Element element, BeanDefinitionBuilder bean) {
        return super.getBeanAssembler(element, bean);
    }

    public void forceParent(BeanDefinition parent) {
        this.forcedParent = parent;
    }

    protected void preProcess(Element element) {
        super.preProcess(element);
        this.targetPropertyConfiguration.reset();
    }

    protected void postProcess(BeanAssembler assembler, Element element) {
        super.postProcess(assembler, element);
        this.forcedParent = null;
    }
}

