/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.mule.config.MuleConfiguration;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.impl.container.MultiContainerContext;
import org.mule.impl.lifecycle.ContainerManagedLifecyclePhase;
import org.mule.impl.lifecycle.GenericLifecycleManager;
import org.mule.impl.registry.AbstractRegistry;
import org.mule.registry.RegistrationException;
import org.mule.registry.ServiceDescriptor;
import org.mule.registry.ServiceDescriptorFactory;
import org.mule.registry.ServiceException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpointBuilder;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.UMOLifecycleManager;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.SpiUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringRegistry
extends AbstractRegistry
implements ApplicationContextAware {
    public static final String REGISTRY_ID = "org.mule.Registry.Spring";
    protected ApplicationContext applicationContext;
    protected MultiContainerContext containerContext;

    public SpringRegistry() {
        super(REGISTRY_ID);
    }

    public SpringRegistry(String id) {
        super(id);
    }

    public SpringRegistry(ApplicationContext applicationContext) {
        super(REGISTRY_ID);
        this.setApplicationContext(applicationContext);
    }

    public SpringRegistry(String id, ApplicationContext applicationContext) {
        super(id);
        this.setApplicationContext(applicationContext);
    }

    protected UMOLifecycleManager createLifecycleManager() {
        GenericLifecycleManager lcm = new GenericLifecycleManager();
        lcm.registerLifecycle(new ContainerManagedLifecyclePhase("initialise", Initialisable.class, "dispose"));
        lcm.registerLifecycle(new ContainerManagedLifecyclePhase("dispose", Disposable.class, "initialise"));
        return lcm;
    }

    protected Object doLookupObject(String key) {
        if (StringUtils.isBlank((String)key)) {
            this.logger.warn((Object)MessageFactory.createStaticMessage("Detected a lookup attempt with an empty or null key"), new Throwable().fillInStackTrace());
            return null;
        }
        try {
            return this.applicationContext.getBean(key);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.logger.debug((Object)e);
            return null;
        }
    }

    protected Collection doLookupObjects(Class type) {
        Map map = this.applicationContext.getBeansOfType(type);
        return map.values();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ServiceDescriptor lookupServiceDescriptor(String type, String name, Properties overrides) throws ServiceException {
        Properties props = SpiUtils.findServiceDescriptor(type, name);
        if (props == null) {
            throw new ServiceException(CoreMessages.failedToLoad(type + " " + name));
        }
        return ServiceDescriptorFactory.create(type, name, props, overrides, this);
    }

    protected synchronized MuleConfiguration getLocalConfiguration() {
        return (MuleConfiguration)this.applicationContext.getBean("_muleConfiguration");
    }

    public TransactionManager getTransactionManager() {
        try {
            return (TransactionManager)this.lookupObject(TransactionManager.class);
        }
        catch (RegistrationException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection getModels() {
        return this.applicationContext.getBeansOfType(UMOModel.class).values();
    }

    public Collection getConnectors() {
        return this.applicationContext.getBeansOfType(UMOConnector.class).values();
    }

    public Collection getAgents() {
        return this.applicationContext.getBeansOfType(UMOAgent.class).values();
    }

    public Collection getEndpoints() {
        return this.applicationContext.getBeansOfType(UMOImmutableEndpoint.class).values();
    }

    public Collection getTransformers() {
        return this.applicationContext.getBeansOfType(UMOTransformer.class).values();
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isRemote() {
        return false;
    }

    public void registerConnector(UMOConnector connector) throws UMOException {
        this.unsupportedOperation("registerConnector", connector);
    }

    public void unregisterConnector(String connectorName) throws UMOException {
        this.unsupportedOperation("unregisterConnector", connectorName);
    }

    public void registerEndpoint(UMOImmutableEndpoint endpoint) throws UMOException {
        this.unsupportedOperation("registerEndpoint", endpoint);
    }

    public void unregisterEndpoint(String endpointName) {
        this.unsupportedOperation("unregisterEndpoint", endpointName);
    }

    protected void doRegisterTransformer(UMOTransformer transformer) throws UMOException {
        this.unsupportedOperation("registerTransformer", transformer);
    }

    public void unregisterTransformer(String transformerName) {
        this.unsupportedOperation("unregistertransformer", transformerName);
    }

    public void registerComponent(UMOComponent component) throws UMOException {
        this.unsupportedOperation("registerComponent", component);
    }

    public void unregisterComponent(String componentName) {
        this.unsupportedOperation("unregisterComponent", componentName);
    }

    public void registerModel(UMOModel model) throws UMOException {
        this.unsupportedOperation("registerModel", model);
    }

    public void unregisterModel(String modelName) {
        this.unsupportedOperation("unregisterModel", modelName);
    }

    public void registerAgent(UMOAgent agent) throws UMOException {
        this.unsupportedOperation("registerAgent", agent);
    }

    public void unregisterAgent(String agentName) throws UMOException {
        this.unsupportedOperation("unregisterAgent", agentName);
    }

    protected void doRegisterObject(String key, Object value, Object metadata) throws RegistrationException {
        this.unsupportedOperation("doRegisterObject", key);
    }

    public void unregisterObject(String key) {
        this.unsupportedOperation("unregisterObject", key);
    }

    public void registerObjects(Map objects) throws RegistrationException {
        this.unsupportedOperation("registryObjects", objects);
    }

    public void setConfiguration(MuleConfiguration config) {
        this.unsupportedOperation("setConfiguration", config);
    }

    public void registerEndpointBuilder(String name, UMOEndpointBuilder builder) throws UMOException {
        this.unsupportedOperation("registerEndpointBuilder", builder);
    }
}

