/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.mule.MuleServer;
import org.mule.RegistryContext;
import org.mule.config.AbstractConfigurationBuilder;
import org.mule.config.ConfigurationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.spring.MuleApplicationContext;
import org.mule.registry.RegistrationException;
import org.mule.registry.Registry;
import org.mule.umo.UMOManagementContext;
import org.mule.util.IOUtils;
import org.springframework.context.ApplicationContext;

public class MuleXmlConfigurationBuilder
extends AbstractConfigurationBuilder {
    private String defaultConfigResource = "default-mule-config.xml";
    private boolean used = false;
    private ApplicationContext parentContext;
    private boolean startContext = true;

    public MuleXmlConfigurationBuilder() {
    }

    public MuleXmlConfigurationBuilder(ApplicationContext parentContext) {
        this.parentContext = parentContext;
    }

    public UMOManagementContext configure(String[] configResources, Properties startupProperties) throws ConfigurationException {
        if (configResources == null) {
            throw new ConfigurationException(CoreMessages.objectIsNull("Configuration Resource"));
        }
        Registry registry = RegistryContext.getOrCreateRegistry();
        try {
            registry.registerObjects(startupProperties);
        }
        catch (RegistrationException e) {
            throw new ConfigurationException(e);
        }
        String[] all = new String[configResources.length + 1];
        all[0] = this.defaultConfigResource;
        System.arraycopy(configResources, 0, all, 1, configResources.length);
        MuleApplicationContext context = this.parentContext != null ? new MuleApplicationContext(all, this.parentContext) : new MuleApplicationContext(all);
        try {
            UMOManagementContext mc = context.getManagementContext();
            MuleServer.setManagementContext(mc);
            if (this.startContext) {
                mc.start();
            }
            registry.getConfiguration().setConfigResources(configResources);
            return mc;
        }
        catch (Exception e) {
            throw new ConfigurationException(CoreMessages.failedToInvokeLifecycle("start", "Mule"), (Throwable)e);
        }
    }

    public boolean isConfigured() {
        return this.used;
    }

    protected InputStream loadConfig(String configResource) throws ConfigurationException {
        InputStream is;
        try {
            is = IOUtils.getResourceAsStream(configResource, this.getClass());
        }
        catch (IOException e) {
            throw new ConfigurationException(CoreMessages.cannotLoadFromClasspath(configResource), (Throwable)e);
        }
        if (is != null) {
            return is;
        }
        throw new ConfigurationException(CoreMessages.cannotLoadFromClasspath(configResource));
    }

    public String getDefaultConfigResource() {
        return this.defaultConfigResource;
    }

    public void setDefaultConfigResource(String defaultConfigResource) {
        this.defaultConfigResource = defaultConfigResource;
    }

    public boolean isStartContext() {
        return this.startContext;
    }

    public void setStartContext(boolean startContext) {
        this.startContext = startContext;
    }

    public ApplicationContext getParentContext() {
        return this.parentContext;
    }

    public void setParentContext(ApplicationContext parentContext) {
        this.parentContext = parentContext;
    }
}

