/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.bootstrap;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.ManagementContextAware;
import org.mule.registry.Registry;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.transformer.DiscoverableTransformer;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassUtils;
import org.mule.util.PropertiesUtils;

public class SimpleRegistryBootstrap
implements Initialisable,
ManagementContextAware {
    public static final String SERVICE_PATH = "META-INF/services/org/mule/config/";
    public static final String REGISTRY_PROPERTIES = "registry-bootstrap.properties";
    public String TRANSFORMER_PREFIX = "transformer.";
    public String OBJECT_PREFIX = "object.";
    protected UMOManagementContext context;
    static /* synthetic */ Class array$B;

    public void setManagementContext(UMOManagementContext context) {
        this.context = context;
    }

    public void initialise() throws InitialisationException {
        Enumeration e = ClassUtils.getResources("META-INF/services/org/mule/config/registry-bootstrap.properties", this.getClass());
        while (e.hasMoreElements()) {
            try {
                URL url = (URL)e.nextElement();
                Properties p = new Properties();
                p.load(url.openStream());
                this.process(p);
            }
            catch (Exception e1) {
                throw new InitialisationException((Throwable)e1, (Initialisable)this);
            }
        }
    }

    protected void process(Properties props) throws NoSuchMethodException, IllegalAccessException, UMOException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        this.registerTransformers(props, this.context.getRegistry());
        this.registerUnnamedObjects(props, this.context.getRegistry());
        this.registerObjects(props, this.context.getRegistry());
    }

    private void registerTransformers(Properties props, Registry registry) throws UMOException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        int i = 1;
        String transString = props.getProperty(this.TRANSFORMER_PREFIX + i);
        String name = null;
        String returnClassString = null;
        while (transString != null) {
            String transClass;
            UMOTransformer trans;
            Class returnClass = null;
            int x = transString.indexOf(",");
            if (x > -1) {
                Properties p = PropertiesUtils.getPropertiesFromString(transString.substring(i + 1), ',');
                name = p.getProperty("name", null);
                returnClassString = p.getProperty("returnClass", null);
            }
            if (returnClassString != null) {
                returnClass = returnClassString.equals("byte[]") ? (array$B == null ? SimpleRegistryBootstrap.class$("[B") : array$B) : ClassUtils.loadClass(returnClassString, this.getClass());
            }
            if (!((trans = (UMOTransformer)ClassUtils.instanciateClass(transClass = x == -1 ? transString : transString.substring(0, x), ClassUtils.NO_ARGS)) instanceof DiscoverableTransformer)) {
                throw new TransformerException(CoreMessages.transformerNotImplementDiscoverable(trans));
            }
            if (returnClass != null) {
                trans.setReturnClass(returnClass);
            }
            if (name != null) {
                trans.setName(name);
            } else {
                name = trans.getName();
                trans.setName("_" + name);
            }
            registry.registerTransformer(trans);
            props.remove(this.TRANSFORMER_PREFIX + i++);
            name = null;
            returnClass = null;
            transString = props.getProperty(this.TRANSFORMER_PREFIX + i);
        }
    }

    private void registerObjects(Properties props, Registry registry) throws UMOException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            Object object = ClassUtils.instanciateClass(entry.getValue().toString(), ClassUtils.NO_ARGS);
            String key = entry.getKey().toString();
            registry.registerObject(key, object);
        }
        props.clear();
    }

    private void registerUnnamedObjects(Properties props, Registry registry) throws UMOException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        int i = 1;
        String objectString = props.getProperty(this.OBJECT_PREFIX + i);
        while (objectString != null) {
            Object o = ClassUtils.instanciateClass(objectString, ClassUtils.NO_ARGS);
            registry.registerObject(this.OBJECT_PREFIX + i + "#" + o.hashCode(), o);
            props.remove(this.OBJECT_PREFIX + i++);
            objectString = props.getProperty(this.OBJECT_PREFIX + i);
        }
    }
}

