/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.io.File;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleRuntimeException;
import org.mule.RegistryContext;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.providers.ConnectionStrategy;
import org.mule.providers.SingleAttemptConnectionStrategy;
import org.mule.registry.RegistrationException;
import org.mule.registry.Registry;
import org.mule.umo.UMOException;
import org.mule.umo.manager.DefaultWorkListener;
import org.mule.util.FileUtils;
import org.mule.util.StringUtils;
import org.mule.util.UUID;

public class MuleConfiguration {
    private static final String DEFAULT_LOG_DIRECTORY = "logs";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    public static final String SYNCHRONOUS_PROPERTY = "synchronous";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_OS_ENCODING = System.getProperty("file.encoding");
    public static final boolean DEFAULT_SYNCHRONOUS = false;
    public static final int DEFAULT_TIMEOUT = 10000;
    public static final int DEFAULT_TRANSACTION_TIMEOUT = 30000;
    public static final String DEFAULT_SYSTEM_MODEL_TYPE = "seda";
    public static final String DEFAULT_WORKING_DIRECTORY = "./.mule";
    public static final String DEFAULT_QUEUE_STORE = "queuestore";
    private boolean synchronous = false;
    private String systemModelType = "seda";
    private String encoding = "UTF-8";
    private String osEncoding = DEFAULT_OS_ENCODING;
    public static final String DEFAULT_THREADING_PROFILE = "defaultThreadingProfile";
    public static final String DEFAULT_MESSAGE_DISPATCHER_THREADING_PROFILE = "defaultMessageDispatcherThreadingProfile";
    public static final String DEFAULT_MESSAGE_REQUESTER_THREADING_PROFILE = "defaultMessageRequesterThreadingProfile";
    public static final String DEFAULT_MESSAGE_RECEIVER_THREADING_PROFILE = "defaultMessageReceiverThreadingProfile";
    public static final String DEFAULT_COMPONENT_THREADING_PROFILE = "defaultComponentThreadingProfile";
    private int synchronousEventTimeout = 10000;
    private int defaultTransactionTimeout = 30000;
    private boolean remoteSync = false;
    private String workingDirectory;
    private String[] configResources = new String[0];
    private boolean clientMode = false;
    private String id;
    private String clusterId;
    private String domainId;
    private ConnectionStrategy connectionStrategy = new SingleAttemptConnectionStrategy();
    private WorkListener workListener = new DefaultWorkListener();

    public MuleConfiguration() {
        this.setWorkingDirectory(DEFAULT_WORKING_DIRECTORY);
        this.setId(UUID.getUUID());
        this.setDomainId("org.mule");
    }

    public boolean isDefaultSynchronousEndpoints() {
        return this.synchronous;
    }

    public void setDefaultSynchronousEndpoints(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public ThreadingProfile getDefaultMessageDispatcherThreadingProfile() {
        return this.getThreadingProfile(DEFAULT_MESSAGE_DISPATCHER_THREADING_PROFILE);
    }

    public ThreadingProfile getDefaultMessageRequesterThreadingProfile() {
        return this.getThreadingProfile(DEFAULT_MESSAGE_REQUESTER_THREADING_PROFILE);
    }

    public ThreadingProfile getDefaultMessageReceiverThreadingProfile() {
        return this.getThreadingProfile(DEFAULT_MESSAGE_RECEIVER_THREADING_PROFILE);
    }

    public ThreadingProfile getDefaultComponentThreadingProfile() {
        return this.getThreadingProfile(DEFAULT_COMPONENT_THREADING_PROFILE);
    }

    public ThreadingProfile getDefaultThreadingProfile() {
        return this.getThreadingProfile(DEFAULT_THREADING_PROFILE);
    }

    private ThreadingProfile getThreadingProfile(String name) {
        ThreadingProfile tp = null;
        Registry registry = RegistryContext.getRegistry();
        if (registry != null) {
            tp = (ThreadingProfile)RegistryContext.getRegistry().lookupObject(name);
        }
        if (null != tp) {
            return tp;
        }
        return ThreadingProfile.DEFAULT_THREADING_PROFILE;
    }

    public int getDefaultSynchronousEventTimeout() {
        return this.synchronousEventTimeout;
    }

    public void setDefaultSynchronousEventTimeout(int synchronousEventTimeout) {
        this.synchronousEventTimeout = synchronousEventTimeout;
    }

    public boolean isDefaultRemoteSync() {
        return this.remoteSync;
    }

    public void setDefaultRemoteSync(boolean remoteSync) {
        this.remoteSync = remoteSync;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getMuleHomeDirectory() {
        return System.getProperty("mule.home");
    }

    public String getLogDirectory() {
        return this.getMuleHomeDirectory() + File.separator + DEFAULT_LOG_DIRECTORY;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = FileUtils.newFile(workingDirectory).getAbsolutePath().replaceAll("\\\\", "/");
        this.updateApplicationProperty("mule.working.dir", this.workingDirectory);
    }

    public String[] getConfigResources() {
        return this.configResources;
    }

    public void setConfigResources(String[] configResources) {
        if (configResources != null) {
            int current = this.configResources.length;
            String[] newResources = new String[configResources.length + current];
            System.arraycopy(this.configResources, 0, newResources, 0, current);
            System.arraycopy(configResources, 0, newResources, current, configResources.length);
            this.configResources = newResources;
        } else {
            this.configResources = configResources;
        }
    }

    public int getDefaultTransactionTimeout() {
        return this.defaultTransactionTimeout;
    }

    public void setDefaultTransactionTimeout(int defaultTransactionTimeout) {
        this.defaultTransactionTimeout = defaultTransactionTimeout;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public ConnectionStrategy getDefaultConnectionStrategy() {
        try {
            return (ConnectionStrategy)BeanUtils.cloneBean((Object)this.connectionStrategy);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.failedToClone("Connection Strategy"), (Throwable)e);
        }
    }

    public void setDefaultConnectionStrategy(ConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public String getDefaultEncoding() {
        return this.encoding;
    }

    public void setDefaultEncoding(String encoding) {
        if (StringUtils.isEmpty((String)encoding)) {
            this.logger.warn((Object)"Cannot set encoding to null or empty String");
            return;
        }
        this.encoding = encoding;
    }

    public String getDefaultOSEncoding() {
        return this.osEncoding;
    }

    public void setDefaultOSEncoding(String osEncoding) {
        this.osEncoding = osEncoding;
    }

    public WorkListener getDefaultWorkListener() {
        return this.workListener;
    }

    public void setDefaultWorkListener(WorkListener workListener) {
        if (workListener == null) {
            throw new NullPointerException("workListener");
        }
        this.workListener = workListener;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new RuntimeException("Cannot set server id to null/blank");
        }
        this.id = id;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    private void updateApplicationProperty(String name, Object value) {
        if (RegistryContext.getRegistry() != null) {
            try {
                RegistryContext.getRegistry().unregisterObject(name);
            }
            catch (UMOException e) {
                // empty catch block
            }
            try {
                RegistryContext.getRegistry().registerObject(name, value);
            }
            catch (RegistrationException e) {
                this.logger.error((Object)e);
            }
        }
    }

    public String getSystemModelType() {
        return this.systemModelType;
    }

    public void setSystemModelType(String systemModelType) {
        this.systemModelType = systemModelType;
    }
}

