/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingDeque;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.SynchronousQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.mule.config.ThreadingProfile;
import org.mule.impl.work.MuleWorkManager;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.util.concurrent.NamedThreadFactory;
import org.mule.util.concurrent.WaitPolicy;

public class ImmutableThreadingProfile
implements ThreadingProfile {
    private int maxThreadsActive;
    private int maxThreadsIdle;
    private int maxBufferSize;
    private long threadTTL;
    private long threadWaitTimeout;
    private int poolExhaustedAction;
    private boolean doThreading;
    private ThreadingProfile.WorkManagerFactory workManagerFactory = new DefaultWorkManagerFactory();
    private RejectedExecutionHandler rejectedExecutionHandler;
    private ThreadFactory threadFactory;

    public ImmutableThreadingProfile(int maxThreadsActive, int maxThreadsIdle, int maxBufferSize, long threadTTL, long threadWaitTimeout, int poolExhaustedAction, boolean doThreading, RejectedExecutionHandler rejectedExecutionHandler, ThreadFactory threadFactory) {
        this.maxThreadsActive = maxThreadsActive;
        this.maxThreadsIdle = maxThreadsIdle;
        this.maxBufferSize = maxBufferSize;
        this.threadTTL = threadTTL;
        this.threadWaitTimeout = threadWaitTimeout;
        this.poolExhaustedAction = poolExhaustedAction;
        this.doThreading = doThreading;
        this.rejectedExecutionHandler = rejectedExecutionHandler;
        this.threadFactory = threadFactory;
    }

    public ImmutableThreadingProfile(ThreadingProfile tp) {
        this(tp.getMaxThreadsActive(), tp.getMaxThreadsIdle(), tp.getMaxBufferSize(), tp.getThreadTTL(), tp.getThreadWaitTimeout(), tp.getPoolExhaustedAction(), tp.isDoThreading(), tp.getRejectedExecutionHandler(), tp.getThreadFactory());
    }

    public int getMaxThreadsActive() {
        return this.maxThreadsActive;
    }

    public int getMaxThreadsIdle() {
        return this.maxThreadsIdle;
    }

    public long getThreadTTL() {
        return this.threadTTL;
    }

    public long getThreadWaitTimeout() {
        return this.threadWaitTimeout;
    }

    public int getPoolExhaustedAction() {
        return this.poolExhaustedAction;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setMaxThreadsActive(int maxThreadsActive) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setMaxThreadsIdle(int maxThreadsIdle) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setThreadTTL(long threadTTL) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setThreadWaitTimeout(long threadWaitTimeout) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setPoolExhaustedAction(int poolExhaustPolicy) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ThreadingProfile.WorkManagerFactory getWorkManagerFactory() {
        return this.workManagerFactory;
    }

    public void setWorkManagerFactory(ThreadingProfile.WorkManagerFactory workManagerFactory) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public UMOWorkManager createWorkManager(String name) {
        return this.workManagerFactory.createWorkManager(this, name);
    }

    public ThreadPoolExecutor createPool() {
        return this.createPool(null);
    }

    public ThreadPoolExecutor createPool(String name) {
        return ImmutableThreadingProfile.createPool(name, this);
    }

    public boolean isDoThreading() {
        return this.doThreading;
    }

    public void setDoThreading(boolean doThreading) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        return "ThreadingProfile{maxThreadsActive=" + this.maxThreadsActive + ", maxThreadsIdle=" + this.maxThreadsIdle + ", maxBufferSize=" + this.maxBufferSize + ", threadTTL=" + this.threadTTL + ", poolExhaustedAction=" + this.poolExhaustedAction + ", threadWaitTimeout=" + this.threadWaitTimeout + ", doThreading=" + this.doThreading + ", workManagerFactory=" + this.workManagerFactory + ", rejectedExecutionHandler=" + this.rejectedExecutionHandler + ", threadFactory=" + this.threadFactory + "}";
    }

    public static ThreadPoolExecutor createPool(String name, ThreadingProfile tp) {
        Object buffer = tp.getMaxBufferSize() > 0 && tp.getMaxThreadsActive() > 1 ? new LinkedBlockingDeque(tp.getMaxBufferSize()) : new SynchronousQueue();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(Math.max(tp.getMaxThreadsIdle(), tp.getMaxThreadsActive()), tp.getMaxThreadsActive(), tp.getThreadTTL(), TimeUnit.MILLISECONDS, (BlockingQueue)buffer);
        if (tp.getThreadFactory() != null) {
            pool.setThreadFactory(tp.getThreadFactory());
        } else if (name != null) {
            pool.setThreadFactory((ThreadFactory)new NamedThreadFactory(name));
        }
        if (tp.getRejectedExecutionHandler() != null) {
            pool.setRejectedExecutionHandler(tp.getRejectedExecutionHandler());
        } else {
            switch (tp.getPoolExhaustedAction()) {
                case 2: {
                    pool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy());
                    break;
                }
                case 4: {
                    pool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
                    break;
                }
                case 3: {
                    pool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
                    break;
                }
                case 1: {
                    pool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());
                    break;
                }
                default: {
                    pool.setRejectedExecutionHandler((RejectedExecutionHandler)new WaitPolicy(tp.getThreadWaitTimeout(), TimeUnit.MILLISECONDS));
                }
            }
        }
        return pool;
    }

    public static class DefaultWorkManagerFactory
    implements ThreadingProfile.WorkManagerFactory {
        public UMOWorkManager createWorkManager(ThreadingProfile profile, String name) {
            return new MuleWorkManager(profile, name);
        }
    }
}

