/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.io.IOException;
import java.util.Properties;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ConfigurationException;
import org.mule.umo.UMOManagementContext;
import org.mule.util.PropertiesUtils;
import org.mule.util.StringUtils;

public abstract class AbstractConfigurationBuilder
implements ConfigurationBuilder {
    public UMOManagementContext configure(String configResources) throws ConfigurationException {
        return this.configure(StringUtils.splitAndTrim(configResources, ",; "), new Properties());
    }

    public UMOManagementContext configure(String configResources, Properties startupProperties) throws ConfigurationException {
        return this.configure(StringUtils.splitAndTrim(configResources, ",; "), startupProperties);
    }

    public UMOManagementContext configure(String[] configResources) throws ConfigurationException {
        return this.configure(configResources, new Properties());
    }

    public UMOManagementContext configure(String[] configResources, String startupPropertiesFile) throws ConfigurationException {
        try {
            Properties props = PropertiesUtils.loadProperties(startupPropertiesFile, this.getClass());
            return this.configure(configResources, props);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }

    public UMOManagementContext configure(String configResources, String startupPropertiesFile) throws ConfigurationException {
        try {
            if (startupPropertiesFile != null) {
                Properties props = PropertiesUtils.loadProperties(startupPropertiesFile, this.getClass());
                return this.configure(configResources, props);
            }
            return this.configure(configResources);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }
}

