/*
 * Decompiled with CFR 0.152.
 */
package org.mule.components.simple;

import java.lang.reflect.Method;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.NoSatisfiableMethodsException;
import org.mule.impl.VoidResult;
import org.mule.umo.UMOEventContext;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

public class NoArgsCallWrapper
implements Callable,
Initialisable {
    private Object delegateInstance;
    private String delegateMethod;
    private String delegateClass;

    public void initialise() throws InitialisationException {
        if (this.delegateInstance == null) {
            if (StringUtils.isBlank((String)this.delegateClass) || StringUtils.isBlank((String)this.delegateMethod)) {
                throw new InitialisationException(CoreMessages.noDelegateClassAndMethodProvidedForNoArgsWrapper(), (Initialisable)this);
            }
        } else if (StringUtils.isNotBlank((String)this.delegateClass)) {
            throw new InitialisationException(CoreMessages.noDelegateClassIfDelegateInstanceSpecified(), (Initialisable)this);
        }
        if (StringUtils.isBlank((String)this.delegateMethod)) {
            throw new InitialisationException(CoreMessages.objectIsNull("delegateMethod"), (Initialisable)this);
        }
    }

    public Object onCall(UMOEventContext context) throws Exception {
        Class clazz = this.delegateInstance == null ? ClassUtils.loadClass(this.delegateClass, this.getClass()) : this.delegateInstance.getClass();
        Method method = ClassUtils.getMethod(clazz, this.delegateMethod, null);
        if (method == null) {
            throw new NoSatisfiableMethodsException((Object)clazz, this.delegateMethod);
        }
        if (this.delegateInstance == null) {
            this.delegateInstance = clazz.newInstance();
        }
        Object result = method.invoke(this.delegateInstance, null);
        if (Void.TYPE.equals(method.getReturnType())) {
            result = VoidResult.getInstance();
        }
        return result;
    }

    public Object getDelegateInstance() {
        return this.delegateInstance;
    }

    public void setDelegateInstance(Object delegateInstance) {
        this.delegateInstance = delegateInstance;
    }

    public String getDelegateMethod() {
        return this.delegateMethod;
    }

    public void setDelegateMethod(String delegateMethod) {
        this.delegateMethod = delegateMethod;
    }

    public String getDelegateClass() {
        return this.delegateClass;
    }

    public void setDelegateClass(String delegateClass) {
        this.delegateClass = delegateClass;
    }
}

