/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.object;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.Iterator;
import java.util.Map;
import org.mule.config.i18n.MessageFactory;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.util.UUID;
import org.mule.util.object.AbstractObjectFactory;
import org.mule.util.object.Identifiable;

public class PrototypeObjectFactory
extends AbstractObjectFactory {
    protected Map instances = null;

    public PrototypeObjectFactory() {
    }

    public PrototypeObjectFactory(String objectClassName) {
        super(objectClassName);
    }

    public PrototypeObjectFactory(String objectClassName, Map properties) {
        super(objectClassName, properties);
    }

    public PrototypeObjectFactory(Class objectClass) {
        super(objectClass);
    }

    public PrototypeObjectFactory(Class objectClass, Map properties) {
        super(objectClass, properties);
    }

    public void initialise() throws InitialisationException {
        this.instances = new ConcurrentHashMap();
    }

    public void dispose() {
        if (this.instances != null) {
            Iterator it = this.instances.values().iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof Disposable)) continue;
                ((Disposable)obj).dispose();
            }
            this.instances.clear();
            this.instances = null;
        }
    }

    public Object getOrCreate() throws Exception {
        Object obj = super.getOrCreate();
        String id = UUID.getUUID();
        if (obj instanceof Identifiable) {
            ((Identifiable)obj).setId(id);
        }
        if (this.instances == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Object factory has not been initialized."), (Initialisable)this);
        }
        this.instances.put(id, obj);
        return obj;
    }

    public Object lookup(String id) throws Exception {
        if (this.instances != null) {
            return this.instances.get(id);
        }
        return null;
    }

    public void release(Object object) throws Exception {
        if (object instanceof Identifiable) {
            this.instances.remove(((Identifiable)object).getId());
        }
        if (object instanceof Disposable) {
            ((Disposable)object).dispose();
        }
    }
}

