/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.mule.MuleServer;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.transaction.AbstractTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionRollbackException;
import org.mule.transaction.TransactionStatusException;
import org.mule.umo.TransactionException;

public class XaTransaction
extends AbstractTransaction {
    private Transaction transaction = null;
    private Map resources = null;
    private TransactionManager txManager;

    public XaTransaction(TransactionManager txManager) {
        this.txManager = txManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBegin() throws TransactionException {
        if (this.txManager == null) {
            throw new IllegalStateException(CoreMessages.objectNotRegistered("Transaction Manager", "Transaction Manager").getMessage());
        }
        try {
            this.txManager.begin();
            XaTransaction xaTransaction = this;
            synchronized (xaTransaction) {
                this.transaction = this.txManager.getTransaction();
            }
        }
        catch (Exception e) {
            throw new TransactionException(CoreMessages.cannotStartTransaction("XA"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit() throws TransactionException {
        try {
            XaTransaction xaTransaction = this;
            synchronized (xaTransaction) {
                TransactionManager txManager = MuleServer.getManagementContext().getTransactionManager();
                txManager.commit();
            }
        }
        catch (RollbackException e) {
            throw new TransactionRollbackException(CoreMessages.transactionMarkedForRollback(), (Throwable)e);
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionRollbackException(CoreMessages.transactionMarkedForRollback(), (Throwable)e);
        }
        catch (Exception e) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCommitFailed(), (Throwable)e);
        }
        finally {
            this.transaction = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRollback() throws TransactionRollbackException {
        try {
            XaTransaction xaTransaction = this;
            synchronized (xaTransaction) {
                TransactionManager txManager = MuleServer.getManagementContext().getTransactionManager();
                txManager.rollback();
            }
        }
        catch (SystemException e) {
            throw new TransactionRollbackException(e);
        }
        finally {
            this.transaction = null;
        }
    }

    public int getStatus() throws TransactionStatusException {
        XaTransaction xaTransaction = this;
        synchronized (xaTransaction) {
            if (this.transaction == null) {
                return 6;
            }
            try {
                return this.transaction.getStatus();
            }
            catch (SystemException e) {
                throw new TransactionStatusException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnly() {
        if (this.transaction == null) {
            throw new IllegalStateException("Current thread is not associated with a transaction.");
        }
        try {
            XaTransaction xaTransaction = this;
            synchronized (xaTransaction) {
                this.transaction.setRollbackOnly();
            }
        }
        catch (SystemException e) {
            throw (IllegalStateException)new IllegalStateException("Failed to set transaction to rollback only: " + e.getMessage()).initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResource(Object key) {
        XaTransaction xaTransaction = this;
        synchronized (xaTransaction) {
            return this.resources == null ? null : this.resources.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResource(Object key) {
        XaTransaction xaTransaction = this;
        synchronized (xaTransaction) {
            return this.resources != null && this.resources.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindResource(Object key, Object resource) throws TransactionException {
        XaTransaction xaTransaction = this;
        synchronized (xaTransaction) {
            if (this.resources == null) {
                this.resources = new HashMap();
            }
            if (this.resources.containsKey(key)) {
                throw new IllegalTransactionStateException(CoreMessages.transactionResourceAlreadyListedForKey(key));
            }
            this.resources.put(key, resource);
        }
    }

    public boolean enlistResource(XAResource resource) throws TransactionException {
        TransactionManager txManager = MuleServer.getManagementContext().getTransactionManager();
        try {
            Transaction tx = txManager.getTransaction();
            if (tx == null) {
                throw new TransactionException(MessageFactory.createStaticMessage("XATransaction is null"));
            }
            return tx.enlistResource(resource);
        }
        catch (RollbackException e) {
            throw new TransactionException(e);
        }
        catch (SystemException e) {
            throw new TransactionException(e);
        }
    }

    public String toString() {
        return this.transaction == null ? " <null>" : this.transaction.toString();
    }
}

