/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.routing.AbstractRouter;
import org.mule.routing.CorrelationPropertiesExtractor;
import org.mule.umo.UMOMessage;
import org.mule.umo.routing.UMOResponseRouter;
import org.mule.util.ClassUtils;
import org.mule.util.properties.PropertyExtractor;

public abstract class AbstractResponseRouter
extends AbstractRouter
implements UMOResponseRouter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int timeout = 10000;
    private boolean failOnTimeout = true;
    protected PropertyExtractor propertyExtractor = new CorrelationPropertiesExtractor();

    public PropertyExtractor getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(PropertyExtractor propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    public void setPropertyExtractorAsString(String className) {
        try {
            this.propertyExtractor = (PropertyExtractor)ClassUtils.instanciateClass(className, null, this.getClass());
        }
        catch (Exception ex) {
            throw (IllegalArgumentException)new IllegalArgumentException("Couldn't instanciate property extractor class " + className).initCause(ex);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected Object getReplyAggregateIdentifier(UMOMessage message) {
        return this.propertyExtractor.getProperty("MULE_CORRELATION_ID", message);
    }

    protected Object getCallResponseAggregateIdentifier(UMOMessage message) {
        return this.propertyExtractor.getProperty("MULE_MESSAGE_ID", message);
    }

    public boolean isFailOnTimeout() {
        return this.failOnTimeout;
    }

    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }
}

