/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.Iterator;
import org.mule.routing.AbstractRouterCollection;
import org.mule.transaction.TransactionCallback;
import org.mule.transaction.TransactionTemplate;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.routing.UMOOutboundRouter;
import org.mule.umo.routing.UMOOutboundRouterCollection;

public class OutboundRouterCollection
extends AbstractRouterCollection
implements UMOOutboundRouterCollection {
    public OutboundRouterCollection() {
        super(2);
    }

    public UMOMessage route(final UMOMessage message, final UMOSession session, final boolean synchronous) throws MessagingException {
        boolean matchfound = false;
        Iterator iterator = this.getRouters().iterator();
        while (iterator.hasNext()) {
            UMOMessage result;
            UMOOutboundRouter umoOutboundRouter = (UMOOutboundRouter)iterator.next();
            if (!umoOutboundRouter.isMatch(message)) continue;
            matchfound = true;
            final UMOOutboundRouter router = umoOutboundRouter;
            UMOComponent component = session.getComponent();
            TransactionTemplate tt = new TransactionTemplate(umoOutboundRouter.getTransactionConfig(), component.getExceptionListener(), this.managementContext);
            TransactionCallback cb = new TransactionCallback(){

                public Object doInTransaction() throws Exception {
                    return router.route(message, session, synchronous);
                }
            };
            try {
                result = (UMOMessage)tt.execute(cb);
            }
            catch (Exception e) {
                throw new RoutingException(message, null, (Throwable)e);
            }
            if (this.isMatchAll()) continue;
            return result;
        }
        if (!matchfound && this.getCatchAllStrategy() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message did not match any routers on: " + session.getComponent().getName() + " invoking catch all strategy"));
            }
            return this.catchAll(message, session, synchronous);
        }
        if (!matchfound) {
            this.logger.warn((Object)("Message did not match any routers on: " + session.getComponent().getName() + " and there is no catch all strategy configured on this router.  Disposing message."));
        }
        return message;
    }

    public UMOEndpoint[] getEndpointsForMessage(UMOMessage message) throws MessagingException {
        ArrayList endpoints = new ArrayList();
        Iterator iterator = this.getRouters().iterator();
        while (iterator.hasNext()) {
            UMOOutboundRouter umoOutboundRouter = (UMOOutboundRouter)iterator.next();
            if (!umoOutboundRouter.isMatch(message)) continue;
            endpoints.addAll(umoOutboundRouter.getEndpoints());
            if (this.isMatchAll()) continue;
            break;
        }
        UMOEndpoint[] result = new UMOEndpoint[endpoints.size()];
        return endpoints.toArray(result);
    }

    protected UMOMessage catchAll(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        if (this.getStatistics().isEnabled()) {
            this.getStatistics().incrementCaughtMessage();
        }
        return this.getCatchAllStrategy().catchMessage(message, session, synchronous);
    }

    public boolean hasEndpoints() {
        Iterator iterator = this.routers.iterator();
        while (iterator.hasNext()) {
            UMOOutboundRouter router = (UMOOutboundRouter)iterator.next();
            if (router.getEndpoints().size() <= 0 && !router.isDynamicEndpoints()) continue;
            return true;
        }
        return false;
    }
}

