/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.routing.outbound.AbstractOutboundRouter;
import org.mule.transformers.TransformerUtils;
import org.mule.umo.UMOException;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutePathNotFoundException;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.TemplateParser;

public class FilteringOutboundRouter
extends AbstractOutboundRouter {
    private List transformers = new LinkedList();
    private UMOFilter filter;
    private boolean useTemplates = false;
    private TemplateParser parser = TemplateParser.createSquareBracesStyleParser();

    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        UMOMessage result = null;
        if (this.endpoints == null || this.endpoints.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), message, null);
        }
        UMOImmutableEndpoint ep = this.getEndpoint(0, message);
        try {
            if (synchronous) {
                result = this.send(session, message, ep);
            } else {
                this.dispatch(session, message, ep);
            }
        }
        catch (UMOException e) {
            throw new CouldNotRouteOutboundMessageException(message, ep, (Throwable)e);
        }
        return result;
    }

    public UMOFilter getFilter() {
        return this.filter;
    }

    public void setFilter(UMOFilter filter) {
        this.filter = filter;
    }

    public boolean isMatch(UMOMessage message) throws RoutingException {
        if (this.getFilter() == null) {
            return true;
        }
        try {
            message = TransformerUtils.applyAllTransformers(this.transformers, message);
        }
        catch (TransformerException e) {
            throw new RoutingException(CoreMessages.transformFailedBeforeFilter(), message, (UMOEndpoint)this.endpoints.get(0), e);
        }
        return this.getFilter().accept(message);
    }

    public List getTransformers() {
        return this.transformers;
    }

    public void setTransformers(List transformers) {
        this.transformers = transformers;
    }

    public void addEndpoint(UMOImmutableEndpoint endpoint) {
        if (!this.useTemplates && this.parser.isContainsTemplate(endpoint.getEndpointURI().toString())) {
            this.useTemplates = true;
        }
        super.addEndpoint(endpoint);
    }

    public UMOImmutableEndpoint getEndpoint(int index, UMOMessage message) throws CouldNotRouteOutboundMessageException {
        if (!this.useTemplates) {
            return (UMOImmutableEndpoint)this.endpoints.get(index);
        }
        UMOImmutableEndpoint ep = (UMOImmutableEndpoint)this.endpoints.get(index);
        String uri = ep.getEndpointURI().toString();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Uri before parsing is: " + uri));
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(ep.getProperties());
        Iterator iterator = message.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            String propertyKey = (String)iterator.next();
            props.put(propertyKey, message.getProperty(propertyKey));
        }
        String newUriString = this.parser.parse(props, uri);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Uri after parsing is: " + uri));
        }
        try {
            MuleEndpointURI newUri = new MuleEndpointURI(newUriString);
            if (!newUri.getScheme().equalsIgnoreCase(ep.getEndpointURI().getScheme())) {
                throw new CouldNotRouteOutboundMessageException(CoreMessages.schemeCannotChangeForRouter(ep.getEndpointURI().getScheme(), newUri.getScheme()), message, ep);
            }
            ((UMOEndpoint)ep).setEndpointURI(newUri);
        }
        catch (EndpointException e) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.templateCausedMalformedEndpoint(uri, newUriString), message, ep, e);
        }
        return ep;
    }

    public boolean isUseTemplates() {
        return this.useTemplates;
    }

    public void setUseTemplates(boolean useTemplates) {
        this.useTemplates = useTemplates;
    }
}

