/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.Iterator;
import org.mule.config.i18n.MessageFactory;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutingException;

public class EndpointSelector
extends FilteringOutboundRouter {
    private String selectorProperty = "endpoint";
    private boolean extractorEnabled = false;

    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        String endpointName;
        if (this.extractorEnabled) {
            if (null == this.getPropertyExtractor()) {
                throw new IllegalArgumentException("No property extractor specified");
            }
            Object property = this.getPropertyExtractor().getProperty(this.getSelectorProperty(), message);
            if (!(property instanceof String)) {
                throw new IllegalArgumentException("No property for " + this.getSelectorProperty());
            }
            endpointName = (String)property;
        } else {
            endpointName = message.getStringProperty(this.getSelectorProperty(), null);
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("selectorProperty '" + this.getSelectorProperty() + "' must be set on message in order to route it.");
        }
        UMOEndpoint ep = this.lookupEndpoint(endpointName);
        if (ep == null) {
            throw new CouldNotRouteOutboundMessageException(MessageFactory.createStaticMessage("No endpoint found with the name " + endpointName), message, ep);
        }
        try {
            if (synchronous) {
                return this.send(session, message, ep);
            }
            this.dispatch(session, message, ep);
            return null;
        }
        catch (UMOException e) {
            throw new CouldNotRouteOutboundMessageException(message, ep, (Throwable)e);
        }
    }

    protected UMOEndpoint lookupEndpoint(String endpointName) {
        Iterator iterator = this.endpoints.iterator();
        while (iterator.hasNext()) {
            UMOEndpoint ep = (UMOEndpoint)iterator.next();
            if (endpointName.equals(ep.getEndpointURI().getEndpointName())) {
                return ep;
            }
            if (endpointName.equals(ep.getName())) {
                return ep;
            }
            if (!endpointName.equals(ep.getEndpointURI().getUri().toString())) continue;
            return ep;
        }
        return null;
    }

    public String getSelectorProperty() {
        return this.selectorProperty;
    }

    public void setSelectorProperty(String selectorProperty) {
        this.selectorProperty = selectorProperty;
    }

    public boolean isExtractorEnabled() {
        return this.extractorEnabled;
    }

    public void setExtractorEnabled(boolean extractorEnabled) {
        this.extractorEnabled = extractorEnabled;
    }
}

