/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleEvent;
import org.mule.routing.AbstractCatchAllStrategy;
import org.mule.transformers.TransformerUtils;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.routing.ComponentRoutingException;
import org.mule.umo.routing.RoutingException;

public class ForwardingCatchAllStrategy
extends AbstractCatchAllStrategy {
    private boolean sendTransformed = false;

    public UMOMessage catchMessage(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        if (this.getEndpoint() == null) {
            throw new ComponentRoutingException(CoreMessages.noCatchAllEndpointSet(), message, this.getEndpoint(), session.getComponent());
        }
        try {
            UMOImmutableEndpoint endpoint = this.getEndpoint();
            if (this.sendTransformed && endpoint.getTransformers() != null) {
                message = TransformerUtils.applyAllTransformers(endpoint.getTransformers(), message);
            }
            MuleEvent newEvent = new MuleEvent(message, endpoint, session, synchronous);
            if (synchronous) {
                UMOMessage result = endpoint.send(newEvent);
                if (this.statistics != null) {
                    this.statistics.incrementRoutedMessage(this.getEndpoint());
                }
                return result;
            }
            endpoint.dispatch(newEvent);
            if (this.statistics != null) {
                this.statistics.incrementRoutedMessage(this.getEndpoint());
            }
            return null;
        }
        catch (Exception e) {
            throw new RoutingException(message, this.getEndpoint(), (Throwable)e);
        }
    }

    public boolean isSendTransformed() {
        return this.sendTransformed;
    }

    public void setSendTransformed(boolean sendTransformed) {
        this.sendTransformed = sendTransformed;
    }
}

