/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.service;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.config.i18n.CoreMessages;
import org.mule.providers.AbstractConnector;
import org.mule.providers.service.TransportFactoryException;
import org.mule.providers.service.TransportServiceDescriptor;
import org.mule.registry.ServiceException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.BeanUtils;
import org.mule.util.ObjectNameHelper;

public class TransportFactory {
    protected static final Log logger = LogFactory.getLog((Class)TransportFactory.class);
    public static final int GET_OR_CREATE_CONNECTOR = 0;
    public static final int ALWAYS_CREATE_CONNECTOR = 1;
    public static final int NEVER_CREATE_CONNECTOR = 2;
    public static final int USE_CONNECTOR = 3;

    public static UMOConnector createConnector(UMOEndpointURI url, UMOManagementContext managementContext) throws TransportFactoryException {
        try {
            String scheme = url.getSchemeMetaInfo();
            TransportServiceDescriptor sd = (TransportServiceDescriptor)RegistryContext.getRegistry().lookupServiceDescriptor("transport", scheme, null);
            if (sd == null) {
                throw new ServiceException(CoreMessages.noServiceTransportDescriptor(scheme));
            }
            UMOConnector connector = sd.createConnector();
            if (connector != null) {
                if (connector instanceof AbstractConnector) {
                    ((AbstractConnector)connector).initialiseFromUrl(url);
                }
            } else {
                throw new TransportFactoryException(CoreMessages.objectNotSetInService("Connector", scheme));
            }
            connector.setName(ObjectNameHelper.getConnectorName(connector));
            return connector;
        }
        catch (Exception e) {
            throw new TransportFactoryException(CoreMessages.failedToCreateObjectWith("Endpoint", url), (Throwable)e);
        }
    }

    public static UMOConnector getOrCreateConnectorByProtocol(UMOEndpointURI uri, UMOManagementContext managementContext) throws TransportFactoryException {
        return TransportFactory.getOrCreateConnectorByProtocol(uri, uri.getCreateConnector(), managementContext);
    }

    public static UMOConnector getOrCreateConnectorByProtocol(UMOImmutableEndpoint endpoint, UMOManagementContext managementContext) throws TransportFactoryException {
        return TransportFactory.getOrCreateConnectorByProtocol(endpoint.getEndpointURI(), endpoint.getCreateConnector(), managementContext);
    }

    private static UMOConnector getOrCreateConnectorByProtocol(UMOEndpointURI uri, int create, UMOManagementContext managementContext) throws TransportFactoryException {
        UMOConnector connector;
        String connectorName = uri.getConnectorName();
        if (null != connectorName && (connector = RegistryContext.getRegistry().lookupConnector(connectorName)) != null) {
            return connector;
        }
        connector = TransportFactory.getConnectorByProtocol(uri.getFullScheme());
        if (1 == create || connector == null && create == 0) {
            connector = TransportFactory.createConnector(uri, managementContext);
            try {
                BeanUtils.populate((Object)connector, (Map)uri.getParams());
                connector.setManagementContext(managementContext);
                managementContext.applyLifecycle(connector);
                managementContext.getRegistry().registerConnector(connector, managementContext);
            }
            catch (Exception e) {
                throw new TransportFactoryException(e);
            }
        } else if (create == 2 && connector == null) {
            logger.warn((Object)("There is no connector for protocol: " + uri.getScheme() + " and 'createConnector' is set to NEVER.  Returning null"));
        }
        return connector;
    }

    public static UMOConnector getConnectorByProtocol(String protocol) {
        UMOConnector resultConnector = null;
        Collection connectors = RegistryContext.getRegistry().getConnectors();
        Iterator iterator = connectors.iterator();
        while (iterator.hasNext()) {
            UMOConnector connector = (UMOConnector)iterator.next();
            if (!connector.supportsProtocol(protocol)) continue;
            if (resultConnector == null) {
                resultConnector = connector;
                continue;
            }
            throw new IllegalStateException(CoreMessages.moreThanOneConnectorWithProtocol(protocol).getMessage());
        }
        return resultConnector;
    }
}

