/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.service;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleSessionHandler;
import org.mule.impl.endpoint.EndpointURIBuilder;
import org.mule.providers.NullPayload;
import org.mule.providers.service.TransportFactoryException;
import org.mule.providers.service.TransportServiceDescriptor;
import org.mule.providers.service.TransportServiceException;
import org.mule.registry.AbstractServiceDescriptor;
import org.mule.transformers.TransformerUtils;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOTransactionFactory;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageDispatcherFactory;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.umo.provider.UMOSessionHandler;
import org.mule.umo.provider.UMOStreamMessageAdapter;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.object.ObjectFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

public class DefaultTransportServiceDescriptor
extends AbstractServiceDescriptor
implements TransportServiceDescriptor {
    private String messageAdapter;
    private String streamMessageAdapter;
    private String messageReceiver;
    private Properties exceptionMappings = new Properties();
    StaticApplicationContext context;

    public DefaultTransportServiceDescriptor(String service, Properties props, ApplicationContext appContext) throws ClassNotFoundException {
        super(service);
        if (appContext != null) {
            this.context = new StaticApplicationContext(appContext);
            AbstractBeanFactory beanFactory = (AbstractBeanFactory)appContext.getAutowireCapableBeanFactory();
            this.context.getBeanFactory().copyConfigurationFrom((ConfigurableBeanFactory)beanFactory);
        } else {
            this.context = new StaticApplicationContext();
        }
        this.messageReceiver = props.getProperty("message.receiver");
        this.messageAdapter = props.getProperty("message.adapter");
        this.streamMessageAdapter = props.getProperty("stream.message.adapter");
        this.registerService("connector", null, props);
        this.registerService("connector.factory", null, props);
        this.registerService("dispatcher.factory", null, props);
        this.registerService("message.receiver", null, props);
        this.registerService("transacted.message.receiver", null, props);
        this.registerService("xa.transacted.message.receiver", null, props);
        this.registerService("message.adapter", null, props);
        this.registerService("stream.message.adapter", null, props);
        this.registerService("inbound.transformer", null, props);
        this.registerService("outbound.transformer", null, props);
        this.registerService("response.transformer", null, props);
        this.registerService("endpoint.builder", null, props);
        this.registerService("session.handler", MuleSessionHandler.class, props);
    }

    protected void registerService(String name, Class defaultService, Properties props) throws ClassNotFoundException {
        Class serviceClass = this.removeClassProperty(name, props);
        if (serviceClass == null) {
            if (defaultService != null) {
                serviceClass = defaultService;
                this.logger.debug((Object)("No connector service registered for key: " + name + ". Using default: " + serviceClass));
            } else {
                this.logger.debug((Object)("No connector service registered for key: " + name + ". No default set either"));
            }
        }
        if (serviceClass != null) {
            RootBeanDefinition bd = new RootBeanDefinition(serviceClass, false);
            bd.setRole(2);
            this.context.registerBeanDefinition(name, (BeanDefinition)bd);
        }
    }

    public UMOMessageAdapter createMessageAdapter(Object message) throws TransportServiceException {
        return this.createMessageAdapter(message, this.messageAdapter);
    }

    public UMOStreamMessageAdapter createStreamMessageAdapter(InputStream in, OutputStream out) throws TransportServiceException {
        if (this.streamMessageAdapter == null) {
            throw new TransportServiceException(CoreMessages.objectNotSetInService("stream.message.adapter", this.service));
        }
        try {
            if (out == null) {
                return (UMOStreamMessageAdapter)ClassUtils.instanciateClass(this.streamMessageAdapter, new Object[]{in});
            }
            return (UMOStreamMessageAdapter)ClassUtils.instanciateClass(this.streamMessageAdapter, new Object[]{in, out});
        }
        catch (Exception e) {
            throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Adapter", this.streamMessageAdapter), (Throwable)e);
        }
    }

    protected UMOMessageAdapter createMessageAdapter(Object message, String clazz) throws TransportServiceException {
        if (message == null) {
            message = NullPayload.getInstance();
        }
        if (this.messageAdapter != null) {
            try {
                return (UMOMessageAdapter)ClassUtils.instanciateClass(clazz, new Object[]{message});
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Adapter", clazz), (Throwable)e);
            }
        }
        throw new TransportServiceException(CoreMessages.objectNotSetInService("Message Adapter", this.getService()));
    }

    protected Object getServiceObject(String name, Class classType) throws TransportServiceException {
        try {
            Object service = classType == null ? this.context.getBean(name) : this.context.getBean(name, classType);
            return service;
        }
        catch (BeansException e) {
            throw new TransportServiceException(CoreMessages.failedToCreateObjectWith(name, classType), (Throwable)e);
        }
    }

    public UMOSessionHandler createSessionHandler() throws TransportServiceException {
        return (UMOSessionHandler)this.getServiceObject("session.handler", UMOSessionHandler.class);
    }

    public UMOMessageReceiver createMessageReceiver(UMOConnector connector, UMOComponent component, UMOImmutableEndpoint endpoint) throws UMOException {
        return this.createMessageReceiver(connector, component, endpoint, null);
    }

    public UMOMessageReceiver createMessageReceiver(UMOConnector connector, UMOComponent component, UMOImmutableEndpoint endpoint, Object[] args) throws UMOException {
        String receiverClass = this.messageReceiver;
        if (receiverClass != null) {
            Object[] newArgs = args != null && args.length != 0 ? new Object[3 + args.length] : new Object[]{connector, component, endpoint};
            if (args != null && args.length != 0) {
                System.arraycopy(args, 0, newArgs, 3, newArgs.length - 3);
            }
            try {
                return (UMOMessageReceiver)ClassUtils.instanciateClass(receiverClass, newArgs);
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Receiver", this.getService()), (Throwable)e);
            }
        }
        throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Receiver", this.getService()));
    }

    public UMOMessageDispatcherFactory createDispatcherFactory() throws TransportServiceException {
        try {
            return (UMOMessageDispatcherFactory)this.context.getBean("dispatcher.factory");
        }
        catch (BeansException e) {
            this.logger.debug((Object)e.getMessage());
            return null;
        }
    }

    public UMOTransactionFactory createTransactionFactory() throws TransportServiceException {
        try {
            return (UMOTransactionFactory)this.context.getBean("transaction.factory");
        }
        catch (BeansException e) {
            this.logger.debug((Object)e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public UMOConnector createConnector() throws TransportServiceException {
        void var1_4;
        block6: {
            try {
                UMOConnector newConnector;
                if (this.context.containsBean("connector.factory")) {
                    ObjectFactory factory = (ObjectFactory)this.context.getBean("connector.factory");
                    newConnector = (UMOConnector)factory.getOrCreate();
                    break block6;
                }
                if (this.context.containsBean("connector")) {
                    newConnector = (UMOConnector)this.context.getBean("connector");
                    break block6;
                }
                throw new TransportServiceException(CoreMessages.objectNotSetInService("Connector", this.getService()));
            }
            catch (TransportServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Connector", null), (Throwable)e);
            }
        }
        if (var1_4.getName() == null) {
            var1_4.setName("_" + var1_4.getProtocol() + "Connector#" + var1_4.hashCode());
        }
        return var1_4;
    }

    public List createInboundTransformers() throws TransportFactoryException {
        return this.getTransformerFromContex("inbound.transformer", "inbound");
    }

    protected List getTransformerFromContex(String name, String type) throws TransportFactoryException {
        if (this.context.containsBean(name)) {
            try {
                UMOTransformer t = (UMOTransformer)this.context.getBean(name);
                this.logger.info((Object)("Loaded default " + type + " transformer: " + t));
                return CollectionUtils.singletonList(t);
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToLoadTransformer(type, name), (Throwable)e);
            }
        }
        return TransformerUtils.UNDEFINED;
    }

    public List createOutboundTransformers() throws TransportFactoryException {
        return this.getTransformerFromContex("outbound.transformer", "outbound");
    }

    public List createResponseTransformers() throws TransportFactoryException {
        return this.getTransformerFromContex("response.transformer", "response");
    }

    public EndpointURIBuilder createEndpointBuilder() throws TransportFactoryException {
        EndpointURIBuilder epb = null;
        if (this.context.containsBean("endpoint.builder")) {
            epb = (EndpointURIBuilder)this.context.getBean("endpoint.builder");
        }
        if (epb == null) {
            throw new TransportFactoryException(CoreMessages.objectNotSetInService("endpoint.builder", this.getService()));
        }
        return epb;
    }

    public void setExceptionMappings(Properties props) {
        this.exceptionMappings = props;
    }

    public Properties getExceptionMappings() {
        return this.exceptionMappings;
    }
}

