/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.resource.spi.work.Work;
import org.mule.MuleServer;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.transaction.TransactionCallback;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.TransactionTemplate;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOMessageAdapter;

public abstract class AbstractReceiverWorker
implements Work {
    protected List messages;
    protected UMOImmutableEndpoint endpoint;
    protected AbstractMessageReceiver receiver;
    protected OutputStream out;

    public AbstractReceiverWorker(List messages, AbstractMessageReceiver receiver) {
        this(messages, receiver, null);
    }

    public AbstractReceiverWorker(List messages, AbstractMessageReceiver receiver, OutputStream out) {
        this.messages = messages;
        this.receiver = receiver;
        this.endpoint = receiver.getEndpoint();
        this.out = out;
    }

    public final void run() {
        this.doRun();
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun() {
        UMOManagementContext managementContext = MuleServer.getManagementContext();
        TransactionTemplate tt = new TransactionTemplate(this.endpoint.getTransactionConfig(), this.endpoint.getConnector().getExceptionListener(), managementContext);
        TransactionCallback cb = new TransactionCallback(){

            public Object doInTransaction() throws Exception {
                UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
                if (tx != null) {
                    AbstractReceiverWorker.this.bindTransaction(tx);
                }
                ArrayList results = new ArrayList(AbstractReceiverWorker.this.messages.size());
                Iterator iterator = AbstractReceiverWorker.this.messages.iterator();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if ((o = AbstractReceiverWorker.this.preProcessMessage(o)) == null) continue;
                    UMOMessageAdapter adapter = o instanceof UMOMessageAdapter ? (UMOMessageAdapter)o : AbstractReceiverWorker.this.endpoint.getConnector().getMessageAdapter(o);
                    MuleMessage muleMessage = new MuleMessage(adapter);
                    AbstractReceiverWorker.this.preRouteMuleMessage(muleMessage);
                    UMOMessage result = AbstractReceiverWorker.this.receiver.routeMessage(muleMessage, tx, tx != null || AbstractReceiverWorker.this.endpoint.isSynchronous(), AbstractReceiverWorker.this.out);
                    if (result == null || (o = AbstractReceiverWorker.this.postProcessMessage(result)) == null) continue;
                    results.add(o);
                }
                return results;
            }
        };
        try {
            List results = (List)tt.execute(cb);
            this.handleResults(results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.messages.clear();
        }
    }

    protected void preRouteMuleMessage(MuleMessage message) throws Exception {
    }

    protected abstract void bindTransaction(UMOTransaction var1) throws TransactionException;

    protected void handleException(Exception e) {
        this.endpoint.getConnector().handleException(e);
    }

    protected void handleResults(List messages) throws Exception {
    }

    protected Object preProcessMessage(Object message) throws Exception {
        return message;
    }

    protected UMOMessage postProcessMessage(UMOMessage message) throws Exception {
        return message;
    }

    public void release() {
    }
}

