/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.ManagementContextAware;
import org.mule.impl.security.MuleSecurityManager;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.security.CryptoFailureException;
import org.mule.umo.security.EncryptionStrategyNotFoundException;
import org.mule.umo.security.SecurityException;
import org.mule.umo.security.SecurityProviderNotFoundException;
import org.mule.umo.security.UMOCredentialsAccessor;
import org.mule.umo.security.UMOEndpointSecurityFilter;
import org.mule.umo.security.UMOSecurityManager;
import org.mule.umo.security.UMOSecurityProvider;
import org.mule.umo.security.UnknownAuthenticationTypeException;
import org.mule.util.StringUtils;

public abstract class AbstractEndpointSecurityFilter
implements UMOEndpointSecurityFilter,
ManagementContextAware {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected UMOSecurityManager securityManager;
    private String securityProviders;
    protected UMOImmutableEndpoint endpoint;
    private boolean inbound = false;
    private boolean authenticate;
    private UMOCredentialsAccessor credentialsAccessor;
    private boolean isInitialised = false;
    protected UMOManagementContext managementContext;

    public void setManagementContext(UMOManagementContext context) {
        this.managementContext = context;
    }

    public final void initialise() throws InitialisationException {
        if (this.securityManager == null) {
            this.securityManager = this.managementContext.getSecurityManager();
        }
        if (this.securityManager == null) {
            throw new InitialisationException(CoreMessages.authSecurityManagerNotSet(), (Initialisable)this);
        }
        if (this.securityProviders != null) {
            MuleSecurityManager localManager = new MuleSecurityManager();
            String[] sp = StringUtils.splitAndTrim(this.securityProviders, ",");
            for (int i = 0; i < sp.length; ++i) {
                UMOSecurityProvider provider = this.securityManager.getProvider(sp[i]);
                if (provider == null) {
                    throw new InitialisationException(CoreMessages.objectNotRegistered("Security Provider", sp[i]), (Initialisable)this);
                }
                localManager.addProvider(provider);
            }
            this.securityManager = localManager;
        }
    }

    protected final synchronized void lazyInit() throws InitialisationException {
        if (!this.isInitialised) {
            this.initialiseEndpoint();
            this.isInitialised = true;
        }
    }

    protected final void initialiseEndpoint() throws InitialisationException {
        if (this.endpoint == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("Endpoint"), (Initialisable)this);
        }
        if (this.endpoint.canReceive()) {
            this.inbound = true;
        } else if (this.endpoint.canSend()) {
            this.inbound = false;
        } else {
            throw new InitialisationException(CoreMessages.authEndpointTypeForFilterMustBe("sender or receiver", this.endpoint.getType()), (Initialisable)this);
        }
        this.doInitialise();
    }

    public boolean isAuthenticate() {
        return this.authenticate;
    }

    public void setAuthenticate(boolean authenticate) {
        this.authenticate = authenticate;
    }

    public void setSecurityManager(UMOSecurityManager manager) {
        this.securityManager = manager;
    }

    public UMOSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public String getSecurityProviders() {
        return this.securityProviders;
    }

    public void setSecurityProviders(String providers) {
        this.securityProviders = providers;
    }

    public UMOImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public synchronized void setEndpoint(UMOImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
        this.isInitialised = false;
    }

    public void authenticate(UMOEvent event) throws SecurityException, UnknownAuthenticationTypeException, CryptoFailureException, SecurityProviderNotFoundException, EncryptionStrategyNotFoundException, InitialisationException {
        this.lazyInit();
        if (this.inbound) {
            this.authenticateInbound(event);
        } else {
            this.authenticateOutbound(event);
        }
    }

    public UMOCredentialsAccessor getCredentialsAccessor() {
        return this.credentialsAccessor;
    }

    public void setCredentialsAccessor(UMOCredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }

    protected abstract void authenticateInbound(UMOEvent var1) throws SecurityException, CryptoFailureException, SecurityProviderNotFoundException, EncryptionStrategyNotFoundException, UnknownAuthenticationTypeException;

    protected abstract void authenticateOutbound(UMOEvent var1) throws SecurityException, SecurityProviderNotFoundException, CryptoFailureException;

    protected abstract void doInitialise() throws InitialisationException;
}

