/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.RegistryContext;
import org.mule.config.MuleConfiguration;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.ManagementContext;
import org.mule.impl.internal.notifications.AdminNotification;
import org.mule.impl.internal.notifications.AdminNotificationListener;
import org.mule.impl.internal.notifications.ComponentNotification;
import org.mule.impl.internal.notifications.ComponentNotificationListener;
import org.mule.impl.internal.notifications.ConnectionNotification;
import org.mule.impl.internal.notifications.ConnectionNotificationListener;
import org.mule.impl.internal.notifications.CustomNotification;
import org.mule.impl.internal.notifications.CustomNotificationListener;
import org.mule.impl.internal.notifications.ExceptionNotification;
import org.mule.impl.internal.notifications.ExceptionNotificationListener;
import org.mule.impl.internal.notifications.ManagementNotification;
import org.mule.impl.internal.notifications.ManagementNotificationListener;
import org.mule.impl.internal.notifications.ManagerNotification;
import org.mule.impl.internal.notifications.ManagerNotificationListener;
import org.mule.impl.internal.notifications.ModelNotification;
import org.mule.impl.internal.notifications.ModelNotificationListener;
import org.mule.impl.internal.notifications.RegistryNotification;
import org.mule.impl.internal.notifications.RegistryNotificationListener;
import org.mule.impl.internal.notifications.SecurityNotification;
import org.mule.impl.internal.notifications.SecurityNotificationListener;
import org.mule.impl.internal.notifications.ServerNotificationManager;
import org.mule.impl.internal.notifications.TransactionNotification;
import org.mule.impl.internal.notifications.TransactionNotificationListener;
import org.mule.impl.lifecycle.ContainerManagedLifecyclePhase;
import org.mule.impl.lifecycle.GenericLifecycleManager;
import org.mule.impl.lifecycle.phases.ManagementContextStartPhase;
import org.mule.impl.lifecycle.phases.ManagementContextStopPhase;
import org.mule.impl.lifecycle.phases.TransientRegistryDisposePhase;
import org.mule.impl.lifecycle.phases.TransientRegistryInitialisePhase;
import org.mule.impl.model.ModelServiceDescriptor;
import org.mule.impl.registry.AbstractRegistry;
import org.mule.impl.registry.ManagementContextDependencyProcessor;
import org.mule.impl.registry.ObjectProcessor;
import org.mule.impl.security.MuleSecurityManager;
import org.mule.impl.work.MuleWorkManager;
import org.mule.registry.AbstractServiceDescriptor;
import org.mule.registry.RegistrationException;
import org.mule.registry.Registry;
import org.mule.registry.ServiceDescriptor;
import org.mule.registry.ServiceDescriptorFactory;
import org.mule.registry.ServiceException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.endpoint.UMOEndpointBuilder;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.UMOLifecycleManager;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.BeanUtils;
import org.mule.util.SpiUtils;
import org.mule.util.UUID;
import org.mule.util.queue.CachingPersistenceStrategy;
import org.mule.util.queue.MemoryPersistenceStrategy;
import org.mule.util.queue.TransactionalQueueManager;

public class TransientRegistry
extends AbstractRegistry {
    protected final transient Log logger = LogFactory.getLog((Class)TransientRegistry.class);
    public static final String REGISTRY_ID = "org.mule.Registry.Transient";
    protected static Map sdCache = new HashMap();
    private Map registry;
    private MuleConfiguration config;

    public TransientRegistry() {
        super(REGISTRY_ID);
        this.init();
    }

    public TransientRegistry(Registry parent) {
        super(REGISTRY_ID, parent);
        this.init();
    }

    private void init() {
        this.registry = new HashMap(8);
        this.getObjectTypeMap(ObjectProcessor.class).put("_muleManagementContextProcessor", new ManagementContextDependencyProcessor());
    }

    protected UMOLifecycleManager createLifecycleManager() {
        GenericLifecycleManager lcm = new GenericLifecycleManager();
        TransientRegistryInitialisePhase initPhase = new TransientRegistryInitialisePhase();
        initPhase.setRegistryScope(0);
        lcm.registerLifecycle(initPhase);
        TransientRegistryDisposePhase disposePhase = new TransientRegistryDisposePhase();
        disposePhase.setRegistryScope(0);
        lcm.registerLifecycle(disposePhase);
        return lcm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitialise() throws InitialisationException {
        int oldScope = this.getDefaultScope();
        this.setDefaultScope(0);
        try {
            this.applyProcessors(this.getConnectors());
            this.applyProcessors(this.getTransformers());
            this.applyProcessors(this.getEndpoints());
            this.applyProcessors(this.getAgents());
            this.applyProcessors(this.getModels());
            this.applyProcessors(this.getServices());
            this.applyProcessors(this.lookupObjects(Object.class));
            MuleServer.getManagementContext().fireNotification(new RegistryNotification((Registry)this, 1002));
        }
        finally {
            this.setDefaultScope(oldScope);
        }
    }

    protected void applyProcessors(Map objects) {
        if (objects == null) {
            return;
        }
        Iterator iterator = objects.values().iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            Collection processors = this.lookupObjects(class$org$mule$impl$registry$ObjectProcessor == null ? TransientRegistry.class$("org.mule.impl.registry.ObjectProcessor") : class$org$mule$impl$registry$ObjectProcessor);
            Iterator iterator2 = processors.iterator();
            while (iterator2.hasNext()) {
                ObjectProcessor op = (ObjectProcessor)iterator2.next();
                op.process(o);
            }
        }
    }

    protected Object doLookupObject(String key) {
        Object o = null;
        if (key != null) {
            Iterator it = this.registry.values().iterator();
            while (it.hasNext()) {
                Map map = (Map)it.next();
                o = map.get(key);
                if (o == null) continue;
                return o;
            }
        }
        return o;
    }

    protected MuleConfiguration getLocalConfiguration() {
        return this.config;
    }

    public void setConfiguration(MuleConfiguration config) {
        this.config = config;
    }

    public Collection doLookupObjects(Class returntype) {
        Map map = (Map)this.registry.get(returntype);
        if (map != null) {
            return map.values();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDescriptor lookupServiceDescriptor(String type, String name, Properties overrides) throws ServiceException {
        AbstractServiceDescriptor.Key key = new AbstractServiceDescriptor.Key(name, overrides);
        ServiceDescriptor sd = (ServiceDescriptor)sdCache.get(key);
        TransientRegistry transientRegistry = this;
        synchronized (transientRegistry) {
            if (sd == null) {
                if (this.getParent() != null) {
                    sd = this.getParent().lookupServiceDescriptor(type, name, overrides);
                    sdCache.put(key, sd);
                } else {
                    sd = this.createServiceDescriptor(type, name, overrides);
                }
            }
        }
        return sd;
    }

    protected ServiceDescriptor createServiceDescriptor(String type, String name, Properties overrides) throws ServiceException {
        Properties props = SpiUtils.findServiceDescriptor(type, name);
        if (props == null) {
            throw new ServiceException(CoreMessages.failedToLoad(type + " " + name));
        }
        return ServiceDescriptorFactory.create(type, name, props, overrides, null);
    }

    protected Map getObjectTypeMap(Object o) {
        Object key;
        HashMap objects;
        if (o == null) {
            Object object = o = Object.class;
        }
        if ((objects = (HashMap)this.registry.get(key = o instanceof Class ? (Class)o : (o instanceof String ? o : o.getClass()))) == null) {
            objects = new HashMap(8);
            this.registry.put(key, objects);
        }
        return objects;
    }

    protected Object applyProcessors(Object object) {
        Object theObject = object;
        Collection processors = this.lookupObjects(ObjectProcessor.class);
        Iterator iterator = processors.iterator();
        while (iterator.hasNext()) {
            ObjectProcessor o = (ObjectProcessor)iterator.next();
            theObject = o.process(theObject);
        }
        return theObject;
    }

    protected void doRegisterObject(String key, Object value) throws RegistrationException {
        this.doRegisterObject(key, value, Object.class, null);
    }

    protected void doRegisterObject(String key, Object value, Object metadata, UMOManagementContext managementContext) throws RegistrationException {
        Map objectMap;
        if (this.isInitialised() || this.isInitialising()) {
            value = this.applyProcessors(value);
        }
        if ((objectMap = this.getObjectTypeMap(metadata)) == null) {
            throw new RegistrationException("No object map exists for type " + metadata);
        }
        objectMap.put(key, value);
    }

    public void unregisterObject(String key) {
        this.getObjectTypeMap(Object.class).remove(key);
    }

    public void registerAgent(UMOAgent agent, UMOManagementContext managementContext) throws UMOException {
        this.registerObject(agent.getName(), agent, UMOAgent.class, managementContext);
    }

    public void registerConnector(UMOConnector connector, UMOManagementContext managementContext) throws UMOException {
        this.registerObject(connector.getName(), connector, UMOConnector.class, managementContext);
    }

    public void registerEndpoint(UMOImmutableEndpoint endpoint, UMOManagementContext managementContext) throws UMOException {
        this.registerObject(endpoint.getName(), endpoint, UMOImmutableEndpoint.class, managementContext);
    }

    public void registerEndpointBuilder(String name, UMOEndpointBuilder builder, UMOManagementContext managementContext) throws UMOException {
        this.registerObject(name, builder, UMOEndpointBuilder.class, managementContext);
    }

    public void registerModel(UMOModel model, UMOManagementContext managementContext) throws UMOException {
        this.registerObject(model.getName(), model, UMOModel.class, managementContext);
    }

    public void registerTransformer(UMOTransformer transformer, UMOManagementContext managementContext) throws UMOException {
        this.registerObject(transformer.getName(), transformer, UMOTransformer.class, managementContext);
    }

    public void registerComponent(UMOComponent component, UMOManagementContext managementContext) throws UMOException {
        this.registerObject(component.getName(), component, UMOComponent.class, managementContext);
    }

    public UMOComponent unregisterComponent(String componentName) {
        return (UMOComponent)this.getObjectTypeMap(UMOComponent.class).remove(componentName);
    }

    public UMOAgent unregisterAgent(String agentName) throws UMOException {
        return (UMOAgent)this.getObjectTypeMap(UMOAgent.class).remove(agentName);
    }

    public UMOConnector unregisterConnector(String connectorName) throws UMOException {
        return (UMOConnector)this.getObjectTypeMap(UMOConnector.class).remove(connectorName);
    }

    public UMOImmutableEndpoint unregisterEndpoint(String endpointName) {
        return (UMOImmutableEndpoint)this.getObjectTypeMap(UMOImmutableEndpoint.class).remove(endpointName);
    }

    public UMOModel unregisterModel(String modelName) {
        return (UMOModel)this.getObjectTypeMap(UMOModel.class).remove(modelName);
    }

    public UMOTransformer unregisterTransformer(String transformerName) {
        return (UMOTransformer)this.getObjectTypeMap(UMOTransformer.class).remove(transformerName);
    }

    public UMOTransformer lookupTransformer(String name) {
        UMOTransformer transformer = super.lookupTransformer(name);
        if (transformer != null) {
            try {
                if (transformer.getEndpoint() != null) {
                    throw new IllegalStateException("Endpoint cannot be set");
                }
                transformer = (UMOTransformer)BeanUtils.cloneBean((Object)transformer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return transformer;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isRemote() {
        return false;
    }

    public static TransientRegistry createNew() throws UMOException {
        GenericLifecycleManager lifecycleManager = new GenericLifecycleManager();
        lifecycleManager.registerLifecycle(new ContainerManagedLifecyclePhase("initialise", Initialisable.class, "dispose"));
        lifecycleManager.registerLifecycle(new ManagementContextStartPhase());
        lifecycleManager.registerLifecycle(new ManagementContextStopPhase());
        lifecycleManager.registerLifecycle(new ContainerManagedLifecyclePhase("dispose", Disposable.class, "initialise"));
        TransientRegistry registry = new TransientRegistry();
        RegistryContext.setRegistry(registry);
        MuleConfiguration config = new MuleConfiguration();
        registry.setConfiguration(config);
        TransactionalQueueManager queueManager = new TransactionalQueueManager();
        queueManager.setPersistenceStrategy(new CachingPersistenceStrategy(new MemoryPersistenceStrategy()));
        ThreadingProfile tp = config.getDefaultThreadingProfile();
        MuleWorkManager workManager = new MuleWorkManager(tp, "MuleServer");
        ServerNotificationManager notificationManager = new ServerNotificationManager();
        notificationManager.registerEventType(ManagerNotificationListener.class, ManagerNotification.class);
        notificationManager.registerEventType(ModelNotificationListener.class, ModelNotification.class);
        notificationManager.registerEventType(ComponentNotificationListener.class, ComponentNotification.class);
        notificationManager.registerEventType(SecurityNotificationListener.class, SecurityNotification.class);
        notificationManager.registerEventType(ManagementNotificationListener.class, ManagementNotification.class);
        notificationManager.registerEventType(AdminNotificationListener.class, AdminNotification.class);
        notificationManager.registerEventType(CustomNotificationListener.class, CustomNotification.class);
        notificationManager.registerEventType(ConnectionNotificationListener.class, ConnectionNotification.class);
        notificationManager.registerEventType(RegistryNotificationListener.class, RegistryNotification.class);
        notificationManager.registerEventType(ExceptionNotificationListener.class, ExceptionNotification.class);
        notificationManager.registerEventType(TransactionNotificationListener.class, TransactionNotification.class);
        MuleSecurityManager securityManager = new MuleSecurityManager();
        ManagementContext context = new ManagementContext(lifecycleManager);
        context.setId(UUID.getUUID());
        MuleServer.setManagementContext(context);
        registry.registerObject("_muleManagementContext", (Object)context, context);
        registry.registerObject("_muleSecurityManager", (Object)securityManager, context);
        registry.registerObject("_muleWorkManager", (Object)workManager, context);
        registry.registerObject("_muleNotificationManager", (Object)notificationManager, context);
        registry.registerObject("_muleQueueManager", (Object)queueManager, context);
        context.setWorkManager(workManager);
        context.setSecurityManager(securityManager);
        context.setNotificationManager(notificationManager);
        context.setQueueManager(queueManager);
        ModelServiceDescriptor sd = (ModelServiceDescriptor)registry.lookupServiceDescriptor("model", config.getSystemModelType(), null);
        UMOModel model = sd.createModel();
        model.setName("_muleSystemModel");
        registry.registerModel(model);
        context.initialise();
        registry.initialise();
        return registry;
    }
}

