/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.RegistryContext;
import org.mule.config.MuleConfiguration;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.ManagementContextAware;
import org.mule.registry.RegistrationException;
import org.mule.registry.Registry;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpointBuilder;
import org.mule.umo.endpoint.UMOEndpointFactory;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.UMOLifecycleManager;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.CollectionUtils;
import org.mule.util.UUID;

public abstract class AbstractRegistry
implements Registry {
    private Registry parent;
    private String id;
    private int defaultScope = 2;
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected UMOLifecycleManager lifecycleManager;

    protected AbstractRegistry(String id) {
        if (id == null) {
            throw new NullPointerException(CoreMessages.objectIsNull("RegistryID").getMessage());
        }
        this.id = id;
        this.lifecycleManager = this.createLifecycleManager();
    }

    protected AbstractRegistry(String id, Registry parent) {
        this(id);
        this.setParent(parent);
    }

    protected abstract UMOLifecycleManager createLifecycleManager();

    protected UMOLifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public final String getRegistryId() {
        return this.id;
    }

    public final synchronized void dispose() {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.doDispose();
            this.lifecycleManager.firePhase(MuleServer.getManagementContext(), "dispose");
            if (this.getParent() != null) {
                this.parent.dispose();
            } else {
                RegistryContext.setRegistry(null);
            }
        }
        catch (UMOException e) {
            this.logger.error((Object)("Failed to cleanly dispose: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void doDispose() {
    }

    public boolean isDisposed() {
        return this.lifecycleManager.isPhaseComplete("dispose");
    }

    public boolean isDisposing() {
        return "dispose".equals(this.lifecycleManager.getExecutingPhase());
    }

    public boolean isInitialised() {
        return this.lifecycleManager.isPhaseComplete("initialise");
    }

    public boolean isInitialising() {
        return "initialise".equals(this.lifecycleManager.getExecutingPhase());
    }

    public final void initialise() throws InitialisationException {
        this.lifecycleManager.checkPhase("initialise");
        if (this.getParent() != null) {
            this.parent.initialise();
        }
        if (this.id == null) {
            this.logger.warn((Object)"No unique id has been set on this registry");
            this.id = UUID.getUUID();
        }
        try {
            this.doInitialise();
            this.lifecycleManager.firePhase(MuleServer.getManagementContext(), "initialise");
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void doInitialise() throws InitialisationException {
    }

    public UMOConnector lookupConnector(String name) {
        return (UMOConnector)this.lookupObject(name);
    }

    public UMOImmutableEndpoint lookupEndpoint(String name, UMOManagementContext managementContext) {
        Object o = this.lookupObject(name);
        if (o instanceof UMOEndpointBuilder) {
            try {
                o = this.lookupEndpointFactory().createInboundEndpoint((UMOEndpointBuilder)o, managementContext);
            }
            catch (UMOException e) {
                this.logger.error((Object)e);
                return null;
            }
        }
        return (UMOImmutableEndpoint)o;
    }

    public UMOImmutableEndpoint lookupEndpoint(String name) {
        return this.lookupEndpoint(name, MuleServer.getManagementContext());
    }

    public UMOEndpointBuilder lookupEndpointBuilder(String name) {
        Object o = this.lookupObject(name);
        if (o instanceof UMOEndpointBuilder) {
            this.logger.debug((Object)("Global endpoint EndpointBuilder for name: " + name + "found"));
            return (UMOEndpointBuilder)o;
        }
        this.logger.debug((Object)("Global endpoint EndpointBuilder not found, attempting to lookup named concrete endpoint builder with name: " + name));
        UMOEndpointBuilder endpointBuilder = (UMOEndpointBuilder)this.lookupObject("&" + name);
        if (endpointBuilder != null) {
            this.logger.debug((Object)("Endpoint builder for concrete endpoint with name: " + name + " found."));
        } else {
            this.logger.debug((Object)("Endpoint builder for concrete endpoint with name: " + name + " NOT found."));
        }
        return endpointBuilder;
    }

    public UMOEndpointFactory lookupEndpointFactory() {
        return (UMOEndpointFactory)this.lookupObject("_muleEndpointFactory");
    }

    public UMOImmutableEndpoint lookupInboundEndpoint(String uri, UMOManagementContext managementContext) throws UMOException {
        return this.lookupEndpointFactory().createInboundEndpoint(uri, managementContext);
    }

    public UMOImmutableEndpoint lookupOutboundEndpoint(String uri, UMOManagementContext managementContext) throws UMOException {
        return this.lookupEndpointFactory().createOutboundEndpoint(uri, managementContext);
    }

    public UMOImmutableEndpoint lookupResponseEndpoint(String uri, UMOManagementContext managementContext) throws UMOException {
        return this.lookupEndpointFactory().createResponseEndpoint(uri, managementContext);
    }

    public UMOImmutableEndpoint createEndpoint(UMOEndpointURI endpointUri, String endpointType, UMOManagementContext managementContext) throws EndpointException, UMOException {
        return this.lookupEndpointFactory().createEndpoint(endpointUri, endpointType, managementContext);
    }

    public UMOTransformer lookupTransformer(String name) {
        return (UMOTransformer)this.lookupObject(name);
    }

    public UMOModel lookupModel(String name) {
        return (UMOModel)this.lookupObject(name);
    }

    public UMOModel lookupSystemModel() {
        return this.lookupModel("_muleSystemModel");
    }

    public Collection getModels() {
        return this.lookupObjects(UMOModel.class);
    }

    public Collection getConnectors() {
        return this.lookupObjects(UMOConnector.class);
    }

    public Collection getAgents() {
        return this.lookupObjects(UMOAgent.class);
    }

    public Collection getEndpoints() {
        return this.lookupObjects(UMOImmutableEndpoint.class);
    }

    public Collection getServices() {
        return this.lookupObjects(UMODescriptor.class);
    }

    public Collection getTransformers() {
        return this.lookupObjects(UMOTransformer.class);
    }

    public UMOAgent lookupAgent(String name) {
        return (UMOAgent)this.lookupObject(name);
    }

    public UMOComponent lookupComponent(String name) {
        return (UMOComponent)this.lookupObject(name);
    }

    public Collection lookupComponents(String model) {
        Collection components = this.lookupObjects(UMOComponent.class);
        ArrayList<UMOComponent> modelComponents = new ArrayList<UMOComponent>();
        Iterator it = components.iterator();
        while (it.hasNext()) {
            UMOComponent component = (UMOComponent)it.next();
            if (!model.equals(component.getModel().getName())) continue;
            modelComponents.add(component);
        }
        return modelComponents;
    }

    public final Object lookupObject(String key, int scope) {
        this.logger.debug((Object)("lookupObject: key=" + key + " scope=" + scope));
        Object o = this.doLookupObject(key);
        if (o == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Failed to find object in Registry ID: " + this.getRegistryId()));
            }
            if (this.getParent() != null && scope > 0) {
                if (this.getParent().isRemote() && scope == 2) {
                    o = this.getParent().lookupObject(key);
                } else if (!this.getParent().isRemote() && scope >= 1) {
                    o = this.getParent().lookupObject(key);
                }
            }
        }
        return o;
    }

    public final Collection lookupObjects(Class type) {
        return this.lookupObjects(type, this.getDefaultScope());
    }

    public final Collection lookupObjects(Class type, int scope) {
        this.logger.debug((Object)("lookupObjects: type=" + type + " scope=" + scope));
        Collection collection = this.doLookupObjects(type);
        if (collection == null) {
            collection = new ArrayList();
        }
        if (this.getParent() != null && scope > 0) {
            Collection collection2;
            if (this.getParent().isRemote() && scope == 2) {
                Collection collection22 = this.getParent().lookupObjects(type);
                if (collection22 != null) {
                    collection.addAll(collection22);
                }
            } else if (!this.getParent().isRemote() && scope >= 1 && (collection2 = this.getParent().lookupObjects(type)) != null) {
                collection = CollectionUtils.union(collection, (Collection)collection2);
            }
        }
        return collection;
    }

    protected abstract Collection doLookupObjects(Class var1);

    public Object lookupObject(String key) {
        return this.lookupObject(key, this.getDefaultScope());
    }

    protected abstract Object doLookupObject(String var1);

    public Registry getParent() {
        return this.parent;
    }

    public void setParent(Registry registry) {
        this.parent = registry;
    }

    protected void unsupportedOperation(String operation, Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Registry: " + this.getRegistryId() + " is read-only so objects cannot be registered or unregistered. Failed to execute operation " + operation + " on object: " + o);
    }

    public void registerConnector(UMOConnector connector) throws UMOException {
        this.registerConnector(connector, MuleServer.getManagementContext());
    }

    public void registerConnector(UMOConnector connector, UMOManagementContext managementContext) throws UMOException {
        this.unsupportedOperation("registerConnector", connector);
    }

    public UMOConnector unregisterConnector(String connectorName) throws UMOException {
        this.unsupportedOperation("unregisterConnector", connectorName);
        return null;
    }

    public void registerEndpoint(UMOImmutableEndpoint endpoint) throws UMOException {
        this.registerEndpoint(endpoint, MuleServer.getManagementContext());
    }

    public void registerEndpoint(UMOImmutableEndpoint endpoint, UMOManagementContext managementContext) throws UMOException {
        this.unsupportedOperation("registerEndpoint", endpoint);
    }

    public UMOImmutableEndpoint unregisterEndpoint(String endpointName) {
        this.unsupportedOperation("unregisterEndpoint", endpointName);
        return null;
    }

    public void registerTransformer(UMOTransformer transformer) throws UMOException {
        this.registerTransformer(transformer, MuleServer.getManagementContext());
    }

    public void registerTransformer(UMOTransformer transformer, UMOManagementContext managementContext) throws UMOException {
        this.unsupportedOperation("registerTransformer", transformer);
    }

    public UMOTransformer unregisterTransformer(String transformerName) {
        this.unsupportedOperation("unregistertransformer", transformerName);
        return null;
    }

    public void registerComponent(UMOComponent component, UMOManagementContext managementContext) throws UMOException {
        this.unsupportedOperation("registerComponent", component);
    }

    public UMOComponent unregisterComponent(String componentName) {
        this.unsupportedOperation("unregisterComponent", componentName);
        return null;
    }

    public void registerModel(UMOModel model) throws UMOException {
        this.registerModel(model, MuleServer.getManagementContext());
    }

    public void registerModel(UMOModel model, UMOManagementContext managementContext) throws UMOException {
        this.unsupportedOperation("registerModel", model);
    }

    public UMOModel unregisterModel(String modelName) {
        this.unsupportedOperation("unregisterModel", modelName);
        return null;
    }

    public void registerAgent(UMOAgent agent) throws UMOException {
        this.registerAgent(agent, MuleServer.getManagementContext());
    }

    public void registerAgent(UMOAgent agent, UMOManagementContext managementContext) throws UMOException {
        this.unsupportedOperation("registerAgent", agent);
    }

    public UMOAgent unregisterAgent(String agentName) throws UMOException {
        this.unsupportedOperation("unregisterAgent", agentName);
        return null;
    }

    public final void registerObject(String key, Object value) throws RegistrationException {
        this.registerObject(key, value, null, null);
    }

    public final void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        this.registerObject(key, value, metadata, null);
    }

    public final void registerObject(String key, Object value, UMOManagementContext managementContext) throws RegistrationException {
        this.registerObject(key, value, null, managementContext);
    }

    public final void registerObject(String key, Object value, Object metadata, UMOManagementContext managementContext) throws RegistrationException {
        this.logger.debug((Object)("registerObject: key=" + key + " value=" + value + " metadata=" + metadata + " managementContext=" + managementContext));
        if (value instanceof ManagementContextAware) {
            if (managementContext == null) {
                throw new RegistrationException("Attempting to register a ManagementContextAware object without providing a ManagementContext.");
            }
            ((ManagementContextAware)value).setManagementContext(managementContext);
        }
        this.doRegisterObject(key, value, metadata, managementContext);
    }

    protected void doRegisterObject(String key, Object value, Object metadata, UMOManagementContext managementContext) throws RegistrationException {
        this.unsupportedOperation("doRegisterObject", key);
    }

    public void unregisterObject(String key) {
        this.unsupportedOperation("unregisterObject", key);
    }

    public final MuleConfiguration getConfiguration() {
        MuleConfiguration config = this.getLocalConfiguration();
        if (config == null && this.getParent() != null) {
            config = this.getParent().getConfiguration();
        }
        if (config == null) {
            config = new MuleConfiguration();
            this.setConfiguration(config);
        }
        return config;
    }

    public void setConfiguration(MuleConfiguration config) {
        this.unsupportedOperation("setConfiguration", config);
    }

    public int getDefaultScope() {
        return this.defaultScope;
    }

    public void setDefaultScope(int scope) {
        if (scope < 0 || scope > 2) {
            throw new IllegalArgumentException("Invalid value for scope: " + scope);
        }
        this.defaultScope = scope;
    }

    protected MuleConfiguration getLocalConfiguration() {
        Collection collection = this.lookupObjects(MuleConfiguration.class);
        if (collection == null) {
            this.logger.warn((Object)"No MuleConfiguration was found in registry");
            return null;
        }
        if (collection.size() > 1) {
            // empty if block
        }
        return (MuleConfiguration)collection.iterator().next();
    }

    public void registerEndpointBuilder(String name, UMOEndpointBuilder builder, UMOManagementContext managementContext) throws UMOException {
        this.unsupportedOperation("registerEndpointBuilder", builder);
    }
}

