/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model.streaming;

import java.util.Iterator;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.RequestContext;
import org.mule.impl.model.AbstractComponent;
import org.mule.transformers.TransformerUtils;
import org.mule.umo.ComponentException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.model.UMOEntryPointResolverSet;

public class StreamingComponent
extends AbstractComponent {
    private static final long serialVersionUID = 2967438446264425730L;
    protected Object service;
    protected UMOEntryPointResolverSet entryPointResolverSet;

    protected void doInitialise() throws InitialisationException {
        try {
            this.service = this.getOrCreateService();
        }
        catch (UMOException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        Iterator iterator = this.inboundRouter.getEndpoints().iterator();
        while (iterator.hasNext()) {
            UMOEndpoint ep = (UMOEndpoint)iterator.next();
            if (!ep.isStreaming()) {
                throw new InitialisationException(CoreMessages.streamingEndpointsMustBeUsedWithStreamingModel(), (Initialisable)this);
            }
            if (!TransformerUtils.isDefined(ep.getTransformers())) continue;
            throw new InitialisationException(CoreMessages.streamingEndpointsDoNotSupportTransformers(), (Initialisable)this);
        }
        if (this.service instanceof Initialisable) {
            ((Initialisable)this.service).initialise();
        }
        if (this.entryPointResolverSet == null) {
            this.entryPointResolverSet = this.model.getEntryPointResolverSet();
        }
    }

    protected UMOMessage doSend(UMOEvent event) throws UMOException {
        this.doDispatch(event);
        return null;
    }

    protected void doDispatch(UMOEvent event) throws UMOException {
        try {
            this.entryPointResolverSet.invoke(this.service, RequestContext.getEventContext());
        }
        catch (UMOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ComponentException(event.getMessage(), this, (Throwable)e);
        }
    }

    protected void doDispose() {
        try {
            this.serviceFactory.release(this.service);
        }
        catch (Exception e) {
            this.logger.warn((Object)e);
        }
    }
}

