/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model.streaming;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.providers.streaming.StreamMessageAdapter;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.routing.UMOOutboundRouter;
import org.mule.umo.routing.UMOOutboundRouterCollection;

public class DeferredOutputStream
extends OutputStream {
    protected final Log logger = LogFactory.getLog((Class)DeferredOutputStream.class);
    private UMOEventContext event;
    private OutputStream out = null;
    private int buffer = 0;

    public DeferredOutputStream(UMOEventContext event) {
        this.event = event;
    }

    public DeferredOutputStream(UMOEventContext event, int buffer) {
        this.event = event;
        this.buffer = buffer;
    }

    public void write(int b) throws IOException {
        if (this.out == null) {
            this.out = this.getOutputStream();
        }
        this.out.write(b);
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.logger.debug((Object)"flushing deferred output stream");
            this.out.flush();
        } else {
            this.logger.debug((Object)"deferred output stream unflushed");
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    protected OutputStream getOutputStream() throws IOException {
        StreamMessageAdapter adapter = (StreamMessageAdapter)this.event.getMessage().getAdapter();
        OutputStream temp = this.getOutputStreamFromRouter();
        if (temp == null) {
            temp = adapter.getOutputStream();
        }
        if (temp == null) {
            throw new IOException("No output stream was found for the current event: " + this.event);
        }
        if (this.getBuffer() > 0) {
            return new BufferedOutputStream(temp, this.getBuffer());
        }
        return temp;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public void setBuffer(int buffer) {
        if (this.out != null) {
            throw new IllegalStateException("The stream buffer cannot be set after the stream has been written to");
        }
        this.buffer = buffer;
    }

    protected OutputStream getOutputStreamFromRouter() throws IOException {
        UMOComponent component = this.event.getComponent();
        UMOEndpointURI endpoint = this.event.getEndpointURI();
        UMOOutboundRouterCollection messageRouter = component.getOutboundRouter();
        if (messageRouter.hasEndpoints()) {
            Iterator iterator = messageRouter.getRouters().iterator();
            while (iterator.hasNext()) {
                UMOOutboundRouter router = (UMOOutboundRouter)iterator.next();
                boolean match = false;
                try {
                    match = router.isMatch(this.event.getMessage());
                }
                catch (MessagingException e) {
                    throw (IOException)new IOException(e.toString()).initCause(e);
                }
                if (!match) continue;
                if (router.getEndpoints().size() != 1) {
                    throw new IOException(CoreMessages.streamingComponentMustHaveOneEndpoint(component.getName()).toString());
                }
                UMOEndpoint ep = (UMOEndpoint)router.getEndpoints().get(0);
                try {
                    return ep.getConnector().getOutputStream(ep, this.event.getMessage());
                }
                catch (UMOException e) {
                    throw (IOException)new IOException(CoreMessages.streamingFailedForEndpoint(endpoint.toString()).toString()).initCause(e);
                }
            }
            throw new IOException(CoreMessages.streamingComponentMustHaveOneEndpoint(component.getName()).toString());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"there are no outbound endpoints configured on this component, the otput stream provided from the message adapter will be used");
        }
        return null;
    }
}

