/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model.resolvers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.List;
import org.mule.impl.NoSatisfiableMethodsException;
import org.mule.impl.TooManySatisfiableMethodsException;
import org.mule.impl.model.resolvers.AbstractEntryPointResolver;
import org.mule.impl.model.streaming.DeferredOutputStream;
import org.mule.impl.model.streaming.StreamingService;
import org.mule.providers.streaming.StreamMessageAdapter;
import org.mule.umo.UMOEventContext;
import org.mule.umo.model.InvocationResult;
import org.mule.util.ClassUtils;

public class StreamingEntryPointResolver
extends AbstractEntryPointResolver {
    private Method streamingMethod;
    private boolean inAndOut = false;

    public void initialise(Object component) throws Exception {
        if (component instanceof StreamingService) {
            this.streamingMethod = StreamingService.class.getMethods()[0];
        } else {
            this.inAndOut = true;
            List methods = ClassUtils.getSatisfiableMethods(component.getClass(), new Class[]{InputStream.class, OutputStream.class}, true, false, null);
            if (methods.size() == 0) {
                this.inAndOut = false;
                methods = ClassUtils.getSatisfiableMethods(component.getClass(), new Class[]{InputStream.class}, true, false, null);
            }
            if (methods.size() == 0) {
                throw new NoSatisfiableMethodsException(component, new Class[]{InputStream.class});
            }
            if (methods.size() > 1) {
                throw new TooManySatisfiableMethodsException(component, new Class[]{InputStream.class, OutputStream.class});
            }
            this.streamingMethod = (Method)methods.get(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InvocationResult invoke(Object component, UMOEventContext context) throws Exception {
        if (this.streamingMethod == null) {
            this.initialise(component);
        }
        StreamMessageAdapter adapter = (StreamMessageAdapter)context.getMessage().getAdapter();
        DeferredOutputStream out = new DeferredOutputStream(context);
        try {
            if (component instanceof StreamingService) {
                InvocationResult invocationResult = this.invokeMethod(component, this.streamingMethod, new Object[]{adapter.getInputStream(), out, context});
                return invocationResult;
            }
            if (this.inAndOut) {
                InvocationResult invocationResult = this.invokeMethod(component, this.streamingMethod, new Object[]{adapter.getInputStream(), out});
                return invocationResult;
            }
            InvocationResult invocationResult = this.invokeMethod(component, this.streamingMethod, new Object[]{adapter.getInputStream()});
            return invocationResult;
        }
        catch (Exception e) {
            this.logger.warn((Object)("Failed to route streaming event via " + component + ": " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            try {
                ((OutputStream)out).flush();
            }
            catch (IOException e) {}
        }
    }
}

