/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model.resolvers;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.model.resolvers.AbstractEntryPointResolver;
import org.mule.umo.UMOEventContext;
import org.mule.umo.model.InvocationResult;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;

public class ExplicitMethodEntryPointResolver
extends AbstractEntryPointResolver {
    private Set methods = new LinkedHashSet(2);

    public void setMethods(Set methods) {
        this.methods = methods;
    }

    public void addMethod(String name) {
        this.methods.add(name);
    }

    public boolean removeMethod(String name) {
        return this.methods.remove(name);
    }

    public InvocationResult invoke(Object component, UMOEventContext context) throws Exception {
        if (this.methods == null || this.methods.size() == 0) {
            throw new IllegalStateException(CoreMessages.objectIsNull("methods").toString());
        }
        Object[] payload = this.getPayloadFromMessage(context);
        Class[] classTypes = ClassUtils.getClassTypes(payload);
        Method method = null;
        Iterator iterator = this.methods.iterator();
        while (iterator.hasNext()) {
            String methodName = (String)iterator.next();
            method = this.getMethodByName(methodName, context);
            if (method == null) {
                method = ClassUtils.getMethod(component.getClass(), methodName, classTypes);
            }
            if (method == null) continue;
            this.addMethodByName(method, context);
            break;
        }
        if (method == null) {
            InvocationResult result = new InvocationResult(2);
            result.setErrorNoMatchingMethods(component, classTypes, this);
            return result;
        }
        return this.invokeMethod(component, method, payload);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ExplicitEntryPointResolver");
        sb.append("{methods=").append(StringMessageUtils.toString(this.methods));
        sb.append("{transformFirst=").append(this.isTransformFirst());
        sb.append(", acceptVoidMethods=").append(this.isAcceptVoidMethods());
        sb.append('}');
        return sb.toString();
    }
}

