/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.OptimizedRequestContext;
import org.mule.impl.RequestContext;
import org.mule.impl.message.ExceptionPayload;
import org.mule.impl.model.MuleProxy;
import org.mule.management.stats.ComponentStatistics;
import org.mule.providers.AbstractConnector;
import org.mule.providers.NullPayload;
import org.mule.providers.ReplyToHandler;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOExceptionPayload;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.UMOLifecycleAdapter;
import org.mule.umo.model.ModelException;
import org.mule.umo.model.UMOEntryPointResolverSet;
import org.mule.umo.model.UMOModel;
import org.mule.util.queue.QueueSession;

public class DefaultMuleProxy
implements MuleProxy {
    private static Log logger = LogFactory.getLog((Class)DefaultMuleProxy.class);
    private UMOEvent event;
    private UMOLifecycleAdapter umo;
    private UMOComponent component;
    private boolean suspended = true;
    private ComponentStatistics stat = null;
    private QueueSession queueSession = null;
    protected UMOManagementContext managementContext;

    public DefaultMuleProxy(Object pojoService, UMOComponent component, UMOManagementContext managementContext) throws UMOException {
        this.component = component;
        this.managementContext = managementContext;
        UMOModel model = component.getModel();
        UMOEntryPointResolverSet resolver = model.getEntryPointResolverSet();
        this.umo = model.getLifecycleAdapterFactory().create(pojoService, component, resolver);
    }

    public void start() throws UMOException {
        this.checkDisposed();
        if (!this.umo.isStarted()) {
            try {
                this.umo.start();
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedToStart("Component '" + this.component.getName() + "'"), (Throwable)e);
            }
        }
    }

    public boolean isStarted() {
        return this.umo.isStarted();
    }

    public void stop() throws UMOException {
        this.checkDisposed();
        if (this.umo.isStarted()) {
            try {
                this.umo.stop();
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedToStop("Component '" + this.component.getName() + "'"), (Throwable)e);
            }
        }
    }

    public void dispose() {
        this.checkDisposed();
    }

    private void checkDisposed() {
        if (this.umo.isDisposed()) {
            throw new IllegalStateException("Component has already been disposed of");
        }
    }

    public void onEvent(QueueSession session, UMOEvent event) {
        this.queueSession = session;
        this.event = event;
    }

    public ComponentStatistics getStatistics() {
        return this.stat;
    }

    public void setStatistics(ComponentStatistics stat) {
        this.stat = stat;
    }

    public Object onCall(UMOEvent event) throws UMOException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("MuleProxy: sync call for Mule UMO " + this.component.getName()));
        }
        UMOMessage returnMessage = null;
        try {
            if (event.getEndpoint().canReceive()) {
                String requestor;
                event = OptimizedRequestContext.unsafeSetEvent(event);
                Object replyTo = event.getMessage().getReplyTo();
                ReplyToHandler replyToHandler = this.getReplyToHandler(event.getMessage(), event.getEndpoint());
                long startTime = 0L;
                if (this.stat.isEnabled()) {
                    startTime = System.currentTimeMillis();
                }
                if (this.component.getName().startsWith("_xfireServiceComponent") || this.component.getName().startsWith("_axisServiceComponent")) {
                    event.getMessage().setBooleanProperty("MULE_IGNORE_METHOD", true);
                }
                returnMessage = this.umo.intercept(null);
                if (this.component.getName().startsWith("_xfireServiceComponent") || this.component.getName().startsWith("_axisServiceComponent")) {
                    returnMessage.removeProperty("MULE_IGNORE_METHOD");
                }
                if (this.stat.isEnabled()) {
                    this.stat.addExecutionTime(System.currentTimeMillis() - startTime);
                }
                if ((event = RequestContext.getEvent()).isStopFurtherProcessing()) {
                    logger.debug((Object)"Event stop further processing has been set, no outbound routing will be performed.");
                }
                if (returnMessage != null && !event.isStopFurtherProcessing()) {
                    if (this.component.getOutboundRouter().hasEndpoints()) {
                        UMOMessage outboundReturnMessage = this.component.getOutboundRouter().route(returnMessage, event.getSession(), event.isSynchronous());
                        if (outboundReturnMessage != null) {
                            returnMessage = outboundReturnMessage;
                        }
                    } else {
                        logger.debug((Object)("Outbound router on component '" + this.component.getName() + "' doesn't have any endpoints configured."));
                    }
                }
                if (returnMessage != null && this.component.getResponseRouter() != null) {
                    logger.debug((Object)"Waiting for response router message");
                    returnMessage = this.component.getResponseRouter().getResponse(returnMessage);
                }
                if (returnMessage != null && replyToHandler != null && ((requestor = (String)returnMessage.getProperty("MULE_REPLYTO_REQUESTOR")) != null && !requestor.equals(this.component.getName()) || requestor == null)) {
                    replyToHandler.processReplyTo(event, returnMessage, replyTo);
                }
            } else {
                returnMessage = event.getSession().sendEvent(event);
                this.processReplyTo(returnMessage);
            }
            if (this.stat.isEnabled()) {
                this.stat.incSentEventSync();
            }
        }
        catch (Exception e) {
            UMOExceptionPayload exceptionPayload;
            event.getSession().setValid(false);
            if (e instanceof MessagingException) {
                this.handleException(e);
            } else {
                this.handleException(new MessagingException(CoreMessages.eventProcessingFailedFor(this.component.getName()), event.getMessage(), (Throwable)e));
            }
            if (returnMessage == null) {
                returnMessage = new MuleMessage((Object)NullPayload.getInstance(), (Map)null);
            }
            if ((exceptionPayload = RequestContext.getExceptionPayload()) == null) {
                exceptionPayload = new ExceptionPayload(e);
            }
            returnMessage.setExceptionPayload(exceptionPayload);
        }
        return returnMessage;
    }

    public void handleException(Exception exception) {
        this.component.getExceptionListener().exceptionThrown(exception);
    }

    public String toString() {
        return "proxy for: " + this.component.toString();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.suspended = false;
    }

    protected ReplyToHandler getReplyToHandler(UMOMessage message, UMOImmutableEndpoint endpoint) {
        Object replyTo = message.getReplyTo();
        ReplyToHandler replyToHandler = null;
        if (replyTo != null) {
            replyToHandler = ((AbstractConnector)endpoint.getConnector()).getReplyToHandler();
            if (endpoint.getResponseTransformers() != null) {
                replyToHandler.setTransformers(endpoint.getResponseTransformers());
            }
        }
        return replyToHandler;
    }

    private void processReplyTo(UMOMessage returnMessage) throws UMOException {
        if (returnMessage != null && returnMessage.getReplyTo() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sending reply to: " + returnMessage.getReplyTo()));
            }
            UMOImmutableEndpoint endpoint = this.managementContext.getRegistry().lookupOutboundEndpoint(returnMessage.getReplyTo().toString(), this.managementContext);
            returnMessage.removeProperty("MULE_REPLYTO");
            MuleEvent replyToEvent = new MuleEvent(returnMessage, endpoint, this.event.getSession(), false);
            this.onEvent(this.queueSession, replyToEvent);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("reply to sent: " + returnMessage.getReplyTo()));
            }
            if (this.stat.isEnabled()) {
                this.stat.incSentReplyToEvent();
            }
        }
    }

    public void run() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("MuleProxy: async onEvent for Mule UMO " + this.component.getName()));
        }
        try {
            if (this.event.getEndpoint().canReceive()) {
                String requestor;
                this.event = OptimizedRequestContext.criticalSetEvent(this.event);
                Object replyTo = this.event.getMessage().getReplyTo();
                ReplyToHandler replyToHandler = this.getReplyToHandler(this.event.getMessage(), this.event.getEndpoint());
                long startTime = 0L;
                if (this.stat.isEnabled()) {
                    startTime = System.currentTimeMillis();
                }
                if (this.component.getName().startsWith("_xfireServiceComponent") || this.component.getName().startsWith("_axisServiceComponent")) {
                    this.event.getMessage().setBooleanProperty("MULE_IGNORE_METHOD", true);
                }
                UMOMessage result = this.umo.intercept(null);
                if (this.component.getName().startsWith("_xfireServiceComponent") || this.component.getName().startsWith("_axisServiceComponent")) {
                    result.removeProperty("MULE_IGNORE_METHOD");
                }
                if (this.stat.isEnabled()) {
                    this.stat.addExecutionTime(System.currentTimeMillis() - startTime);
                }
                this.event = RequestContext.getEvent();
                if (result != null && !this.event.isStopFurtherProcessing()) {
                    this.component.getOutboundRouter().route(result, this.event.getSession(), this.event.isSynchronous());
                }
                if (result != null && replyToHandler != null && ((requestor = (String)result.getProperty("MULE_REPLYTO_REQUESTOR")) != null && !requestor.equals(this.component.getName()) || requestor == null)) {
                    replyToHandler.processReplyTo(this.event, result, replyTo);
                }
            } else {
                this.event.getEndpoint().dispatch(this.event);
            }
            if (this.stat.isEnabled()) {
                this.stat.incSentEventASync();
            }
        }
        catch (Exception e) {
            this.event.getSession().setValid(false);
            if (e instanceof MessagingException) {
                this.handleException(e);
            }
            this.handleException(new MessagingException(CoreMessages.eventProcessingFailedFor(this.component.getName()), this.event.getMessage(), (Throwable)e));
        }
    }

    public void release() {
    }
}

