/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.beans.ExceptionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.DefaultComponentExceptionStrategy;
import org.mule.impl.DefaultLifecycleAdapterFactory;
import org.mule.impl.internal.notifications.ModelNotification;
import org.mule.impl.model.AbstractComponent;
import org.mule.impl.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.UMOLifecycleAdapterFactory;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.model.UMOEntryPointResolverSet;
import org.mule.umo.model.UMOModel;

public abstract class AbstractModel
implements UMOModel {
    public static final String DEFAULT_MODEL_NAME = "main";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String name = "main";
    private UMOEntryPointResolverSet entryPointResolverSet = new LegacyEntryPointResolverSet();
    private UMOLifecycleAdapterFactory lifecycleAdapterFactory = new DefaultLifecycleAdapterFactory();
    protected UMOManagementContext managementContext;
    private AtomicBoolean initialised = new AtomicBoolean(false);
    private AtomicBoolean started = new AtomicBoolean(false);
    private ExceptionListener exceptionListener = new DefaultComponentExceptionStrategy();

    public AbstractModel() {
        this.entryPointResolverSet = new LegacyEntryPointResolverSet();
        this.lifecycleAdapterFactory = new DefaultLifecycleAdapterFactory();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UMOEntryPointResolverSet getEntryPointResolverSet() {
        return this.entryPointResolverSet;
    }

    public void setEntryPointResolverSet(UMOEntryPointResolverSet entryPointResolverSet) {
        this.entryPointResolverSet = entryPointResolverSet;
    }

    public UMOLifecycleAdapterFactory getLifecycleAdapterFactory() {
        return this.lifecycleAdapterFactory;
    }

    public void setLifecycleAdapterFactory(UMOLifecycleAdapterFactory lifecycleAdapterFactory) {
        this.lifecycleAdapterFactory = lifecycleAdapterFactory;
    }

    public void dispose() {
        this.fireNotification(new ModelNotification(this, 209));
        this.fireNotification(new ModelNotification(this, 210));
    }

    public void stop() throws UMOException {
        this.fireNotification(new ModelNotification(this, 207));
        this.started.set(false);
        this.fireNotification(new ModelNotification(this, 208));
    }

    public void start() throws UMOException {
        if (!this.initialised.get()) {
            throw new IllegalStateException("Not Initialised");
        }
        if (!this.started.get()) {
            this.fireNotification(new ModelNotification(this, 205));
            this.started.set(true);
            this.fireNotification(new ModelNotification(this, 206));
        } else {
            this.logger.debug((Object)"Model already started");
        }
    }

    public void startComponent(UMOComponent component) throws UMOException {
        if (component.isStarted()) {
            this.logger.info((Object)("Component is already started: " + component));
        } else if (component.getInitialState().equals("started")) {
            component.start();
            this.logger.info((Object)("Component " + component + " has been started successfully"));
        } else if (component.getInitialState().equals("paused")) {
            ((AbstractComponent)component).start(true);
            this.logger.info((Object)("Component " + component + " has been started and paused (initial state = 'paused')"));
        } else {
            this.logger.info((Object)("Component " + component + " has not been started (initial state = 'stopped')"));
        }
        this.logger.info((Object)("Mule " + component.toString() + " has been started successfully"));
    }

    public void stopComponent(UMOComponent component) throws UMOException {
        component.stop();
        this.logger.info((Object)("Mule " + this.name + " has been stopped successfully"));
    }

    public void pauseComponent(UMOComponent component) throws UMOException {
        component.pause();
        this.logger.info((Object)("Mule Component " + this.name + " has been paused successfully"));
    }

    public void resumeComponent(UMOComponent component) throws UMOException {
        component.resume();
        this.logger.info((Object)("Mule Component " + this.name + " has been resumed successfully"));
    }

    public void initialise() throws InitialisationException {
        if (!this.initialised.get()) {
            this.fireNotification(new ModelNotification(this, 201));
            this.initialised.set(true);
            this.fireNotification(new ModelNotification(this, 202));
        } else {
            this.logger.debug((Object)"Model already initialised");
        }
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    void fireNotification(UMOServerNotification notification) {
        if (this.managementContext != null) {
            this.managementContext.fireNotification(notification);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("ManagementContext is not yet available for firing notifications, ignoring event: " + notification));
        }
    }

    public void setManagementContext(UMOManagementContext context) {
        this.managementContext = context;
    }
}

