/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.endpoint;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.impl.endpoint.EndpointURIEndpointBuilder;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.endpoint.UMOEndpointBuilder;
import org.mule.umo.endpoint.UMOEndpointFactory;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;

public class EndpointFactory
implements UMOEndpointFactory {
    protected static final Log logger = LogFactory.getLog((Class)EndpointFactory.class);
    public static final int GET_OR_CREATE_CONNECTOR = 0;
    public static final int ALWAYS_CREATE_CONNECTOR = 1;
    public static final int NEVER_CREATE_CONNECTOR = 2;
    public static final int USE_CONNECTOR = 3;

    public UMOImmutableEndpoint createInboundEndpoint(String uri, UMOManagementContext managementContext) throws UMOException {
        logger.debug((Object)("EndpointFactory request for inbound endpoint for uri: " + uri));
        UMOEndpointBuilder endpointBuilder = this.lookupEndpointBuilder(uri);
        if (endpointBuilder == null) {
            logger.debug((Object)"Named EndpointBuilder not found, creating endpoint from uri");
            endpointBuilder = new EndpointURIEndpointBuilder(uri, managementContext);
        }
        return this.createNewInboundEndpoint(endpointBuilder, managementContext);
    }

    public UMOImmutableEndpoint createOutboundEndpoint(String uri, UMOManagementContext managementContext) throws UMOException {
        logger.debug((Object)("EndpointFactory request for outbound endpoint for uri: " + uri));
        UMOEndpointBuilder endpointBuilder = this.lookupEndpointBuilder(uri);
        if (endpointBuilder == null) {
            logger.debug((Object)"Named EndpointBuilder not found, creating endpoint from uri");
            endpointBuilder = new EndpointURIEndpointBuilder(uri, managementContext);
        }
        return this.createNewOutboundEndpoint(endpointBuilder, managementContext);
    }

    public UMOImmutableEndpoint createResponseEndpoint(String uri, UMOManagementContext managementContext) throws UMOException {
        logger.debug((Object)("EndpointFactory request for response endpoint for uri: " + uri));
        UMOEndpointBuilder endpointBuilder = this.lookupEndpointBuilder(uri);
        if (endpointBuilder == null) {
            logger.debug((Object)"Named EndpointBuilder not found, creating endpoint from uri");
            endpointBuilder = new EndpointURIEndpointBuilder(uri, managementContext);
        }
        return this.createNewResponseEndpoint(endpointBuilder, managementContext);
    }

    public UMOImmutableEndpoint createEndpoint(UMOEndpointURI uri, String type, UMOManagementContext managementContext) throws UMOException {
        logger.debug((Object)("EndpointFactory request for endpoint of type: " + type + ", for uri: " + uri));
        UMOEndpointBuilder endpointBuilder = null;
        if (uri.getEndpointName() != null) {
            endpointBuilder = this.lookupEndpointBuilder(uri.getEndpointName());
            if (endpointBuilder == null) {
                throw new IllegalArgumentException("The endpoint with name: " + uri.getEndpointName() + "was not found.");
            }
        } else {
            logger.debug((Object)"Named EndpointBuilder not found, creating endpoint from uri");
            endpointBuilder = new EndpointURIEndpointBuilder(uri, managementContext);
        }
        if ("receiver".equals(type)) {
            return endpointBuilder.buildInboundEndpoint();
        }
        if ("sender".equals(type)) {
            return endpointBuilder.buildOutboundEndpoint();
        }
        if ("response".equals(type)) {
            return endpointBuilder.buildResponseEndpoint();
        }
        throw new IllegalArgumentException("The endpoint type: " + type + "is not recognized.");
    }

    protected UMOEndpointBuilder lookupEndpointBuilder(String endpointName) {
        logger.debug((Object)("Looking up EndpointBuilder with name:" + endpointName + " in registry"));
        UMOEndpointBuilder endpointBuilder = RegistryContext.getRegistry().lookupEndpointBuilder(endpointName);
        if (endpointBuilder != null) {
            logger.debug((Object)("EndpointBuilder with name:" + endpointName + " FOUND"));
        }
        return endpointBuilder;
    }

    public UMOImmutableEndpoint createInboundEndpoint(UMOEndpointBuilder builder, UMOManagementContext managementContext) throws UMOException {
        return this.createNewInboundEndpoint(builder, managementContext);
    }

    public UMOImmutableEndpoint createOutboundEndpoint(UMOEndpointBuilder builder, UMOManagementContext managementContext) throws UMOException {
        return this.createNewOutboundEndpoint(builder, managementContext);
    }

    public UMOImmutableEndpoint createResponseEndpoint(UMOEndpointBuilder builder, UMOManagementContext managementContext) throws UMOException {
        return this.createNewResponseEndpoint(builder, managementContext);
    }

    protected UMOImmutableEndpoint createNewInboundEndpoint(UMOEndpointBuilder builder, UMOManagementContext managementContext) throws UMOException {
        return builder.buildInboundEndpoint();
    }

    protected UMOImmutableEndpoint createNewOutboundEndpoint(UMOEndpointBuilder builder, UMOManagementContext managementContext) throws UMOException {
        return builder.buildOutboundEndpoint();
    }

    protected UMOImmutableEndpoint createNewResponseEndpoint(UMOEndpointBuilder builder, UMOManagementContext managementContext) throws UMOException {
        return builder.buildResponseEndpoint();
    }
}

