/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.endpoint;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.mule.MuleException;
import org.mule.RegistryContext;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleTransactionConfig;
import org.mule.impl.endpoint.InboundEndpoint;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.OutboundEndpoint;
import org.mule.impl.endpoint.ResponseEndpoint;
import org.mule.providers.AbstractConnector;
import org.mule.providers.ConnectionStrategy;
import org.mule.providers.SingleAttemptConnectionStrategy;
import org.mule.providers.service.TransportFactory;
import org.mule.providers.service.TransportFactoryException;
import org.mule.providers.service.TransportServiceDescriptor;
import org.mule.registry.ServiceException;
import org.mule.transformers.TransformerUtils;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOTransactionConfig;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpointBuilder;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.security.UMOEndpointSecurityFilter;
import org.mule.util.MuleObjectHelper;
import org.mule.util.ObjectNameHelper;
import org.mule.util.StringUtils;

public abstract class AbstractEndpointBuilder
implements UMOEndpointBuilder {
    public static final int GET_OR_CREATE_CONNECTOR = 0;
    public static final int ALWAYS_CREATE_CONNECTOR = 1;
    public static final int NEVER_CREATE_CONNECTOR = 2;
    public static final int USE_CONNECTOR = 3;
    protected UMOConnector connector;
    protected UMOEndpointURI endpointURI;
    protected List transformers = TransformerUtils.UNDEFINED;
    protected List responseTransformers = TransformerUtils.UNDEFINED;
    protected String name;
    protected Map properties = new HashMap();
    protected UMOTransactionConfig transactionConfig;
    protected UMOFilter filter;
    protected Boolean deleteUnacceptedMessages;
    protected UMOEndpointSecurityFilter securityFilter;
    protected Boolean synchronous;
    protected Boolean remoteSync;
    protected Integer remoteSyncTimeout;
    protected Boolean streaming;
    protected String initialState = "started";
    protected String endpointEncoding;
    protected Integer createConnector;
    protected String registryId = null;
    protected UMOManagementContext managementContext;
    protected ConnectionStrategy connectionStrategy;

    public UMOImmutableEndpoint buildInboundEndpoint() throws EndpointException, InitialisationException {
        return this.doBuildInboundEndpoint();
    }

    public UMOImmutableEndpoint buildOutboundEndpoint() throws EndpointException, InitialisationException {
        return this.doBuildOutboundEndpoint();
    }

    public UMOImmutableEndpoint buildResponseEndpoint() throws EndpointException, InitialisationException {
        return this.doBuildResponseEndpoint();
    }

    protected void configureEndpoint(MuleEndpoint ep) throws InitialisationException, EndpointException {
        this.endpointURI.initialise();
        ep.setEndpointURI(this.endpointURI);
        ep.setCreateConnector(this.getCreateConnector());
        UMOConnector connector = this.getConnector();
        ep.setConnector(connector);
        ep.setSecurityFilter(this.getSecurityFilter());
        ep.setTransactionConfig(this.getTransactionConfig());
        ep.setProperties(this.getProperties());
        ep.setName(this.getName(ep));
        ep.setConnectionStrategy(this.getConnectionStrategy(connector));
        ep.setDeleteUnacceptedMessages(this.getDeleteUnacceptedMessages(connector));
        ep.setEncoding(this.getEndpointEncoding(connector));
        ep.setFilter(this.getFilter(connector));
        ep.setInitialState(this.getInitialState(connector));
        ep.setRemoteSyncTimeout(this.getRemoteSyncTimeout(connector));
        ep.setStreaming(this.getStreaming(connector));
        boolean remoteSync = this.getRemoteSync(connector);
        ep.setRemoteSync(remoteSync);
        if (remoteSync) {
            ep.setSynchronous(true);
        } else if (this.synchronous != null) {
            ep.setSynchronous(this.synchronous);
        }
        ep.setManagementContext(this.managementContext);
    }

    protected UMOImmutableEndpoint doBuildInboundEndpoint() throws InitialisationException, EndpointException {
        InboundEndpoint ep = new InboundEndpoint();
        this.configureEndpoint(ep);
        ep.setTransformers(this.getInboundTransformers(ep.getConnector(), ep.getEndpointURI()));
        ep.setResponseTransformers(this.getResponseTransformers(ep.getConnector(), ep.getEndpointURI()));
        return ep;
    }

    protected UMOImmutableEndpoint doBuildOutboundEndpoint() throws InitialisationException, EndpointException {
        OutboundEndpoint ep = new OutboundEndpoint();
        this.configureEndpoint(ep);
        ep.setTransformers(this.getOutboundTransformers(ep.getConnector(), ep.getEndpointURI()));
        return ep;
    }

    protected UMOImmutableEndpoint doBuildResponseEndpoint() throws InitialisationException, EndpointException {
        ResponseEndpoint ep = new ResponseEndpoint();
        this.configureEndpoint(ep);
        ep.setTransformers(this.getInboundTransformers(ep.getConnector(), ep.getEndpointURI()));
        return ep;
    }

    protected boolean getStreaming(UMOConnector connector) {
        return this.streaming != null ? this.streaming.booleanValue() : this.getDefaultStreaming(connector);
    }

    protected boolean getDefaultStreaming(UMOConnector connector) {
        return false;
    }

    protected ConnectionStrategy getConnectionStrategy(UMOConnector connector) {
        return this.connectionStrategy != null ? this.connectionStrategy : this.getDefaultConnectionStrategy(connector);
    }

    protected ConnectionStrategy getDefaultConnectionStrategy(UMOConnector connector) {
        return new SingleAttemptConnectionStrategy();
    }

    protected UMOTransactionConfig getTransactionConfig() {
        return this.transactionConfig != null ? this.transactionConfig : this.getDefaultTransactionConfig();
    }

    protected UMOTransactionConfig getDefaultTransactionConfig() {
        return new MuleTransactionConfig();
    }

    protected UMOEndpointSecurityFilter getSecurityFilter() {
        return this.securityFilter != null ? this.securityFilter : this.getDefaultSecurityFilter();
    }

    protected UMOEndpointSecurityFilter getDefaultSecurityFilter() {
        return null;
    }

    protected UMOConnector getConnector() throws EndpointException {
        return this.connector != null ? this.connector : this.getDefaultConnector();
    }

    protected UMOConnector getDefaultConnector() throws EndpointException {
        return this.getConnector(this.endpointURI, this.managementContext);
    }

    protected int getCreateConnector() {
        if (this.createConnector != null) {
            return this.createConnector;
        }
        return this.endpointURI.getCreateConnector();
    }

    protected int getDefaultCreateConnector() {
        return 0;
    }

    protected String getName(UMOImmutableEndpoint endpoint) {
        String uriName = this.endpointURI.getEndpointName();
        return this.name != null ? this.name : (StringUtils.isNotEmpty((String)uriName) ? uriName : ObjectNameHelper.getEndpointName(endpoint));
    }

    protected Map getProperties() {
        Map<Object, Object> props = new HashMap<Object, Object>();
        if (this.properties != null) {
            props.putAll(this.properties);
        }
        if (this.endpointURI.getParams() != null) {
            props.putAll(this.endpointURI.getParams());
        }
        props = Collections.unmodifiableMap(props);
        return props;
    }

    protected boolean getRemoteSync(UMOConnector connector) {
        return this.remoteSync != null ? this.remoteSync.booleanValue() : this.getDefaultRemoteSync(connector);
    }

    protected boolean getDefaultRemoteSync(UMOConnector connector) {
        return false;
    }

    protected boolean getDeleteUnacceptedMessages(UMOConnector connector) {
        return this.deleteUnacceptedMessages != null ? this.deleteUnacceptedMessages.booleanValue() : this.getDefaultDeleteUnacceptedMessages(connector);
    }

    protected boolean getDefaultDeleteUnacceptedMessages(UMOConnector connector) {
        return connector.isRemoteSyncEnabled();
    }

    protected String getEndpointEncoding(UMOConnector connector) {
        return this.endpointEncoding != null ? this.endpointEncoding : this.getDefaultEndpointEncoding(connector);
    }

    protected String getDefaultEndpointEncoding(UMOConnector connector) {
        if (this.managementContext != null) {
            return this.managementContext.getRegistry().getConfiguration().getDefaultEncoding();
        }
        return System.getProperty("file.encoding");
    }

    protected UMOFilter getFilter(UMOConnector connector) {
        return this.filter != null ? this.filter : this.getDefaultFilter(connector);
    }

    protected UMOFilter getDefaultFilter(UMOConnector connector) {
        return null;
    }

    protected String getInitialState(UMOConnector connector) {
        return this.initialState != null ? this.initialState : this.getDefaultInitialState(connector);
    }

    protected String getDefaultInitialState(UMOConnector connector) {
        return "started";
    }

    protected int getRemoteSyncTimeout(UMOConnector connector) {
        return this.remoteSyncTimeout != null ? this.remoteSyncTimeout.intValue() : this.getDefaultRemoteSyncTimeout(connector);
    }

    protected int getDefaultRemoteSyncTimeout(UMOConnector connector) {
        return 0;
    }

    protected List getInboundTransformers(UMOConnector connector, UMOEndpointURI endpointURI) throws TransportFactoryException {
        if (TransformerUtils.isDefined(this.transformers)) {
            return this.transformers;
        }
        List transformers = this.getTransformersFromString(endpointURI.getTransformers());
        if (TransformerUtils.isDefined(transformers)) {
            return transformers;
        }
        return this.getDefaultInboundTransformers(connector);
    }

    protected List getDefaultInboundTransformers(UMOConnector connector) throws TransportFactoryException {
        try {
            return TransformerUtils.getDefaultInboundTransformers(this.getNonNullServiceDescriptor(this.endpointURI.getSchemeMetaInfo(), this.getOverrides(connector)));
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
    }

    protected List getOutboundTransformers(UMOConnector connector, UMOEndpointURI endpointURI) throws TransportFactoryException {
        if (TransformerUtils.isDefined(this.transformers)) {
            return this.transformers;
        }
        List transformers = this.getTransformersFromString(endpointURI.getTransformers());
        if (TransformerUtils.isDefined(transformers)) {
            return transformers;
        }
        return this.getDefaultOutboundTransformers(connector);
    }

    protected List getDefaultOutboundTransformers(UMOConnector connector) throws TransportFactoryException {
        try {
            return TransformerUtils.getDefaultOutboundTransformers(this.getNonNullServiceDescriptor(this.endpointURI.getSchemeMetaInfo(), this.getOverrides(connector)));
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
    }

    protected List getResponseTransformers(UMOConnector connector, UMOEndpointURI endpointURI) throws TransportFactoryException {
        if (TransformerUtils.isDefined(this.responseTransformers)) {
            return this.responseTransformers;
        }
        List transformers = this.getTransformersFromString(endpointURI.getResponseTransformers());
        if (TransformerUtils.isDefined(transformers)) {
            return transformers;
        }
        return this.getDefaultResponseTransformers(connector);
    }

    protected List getDefaultResponseTransformers(UMOConnector connector) throws TransportFactoryException {
        try {
            return TransformerUtils.getDefaultResponseTransformers(this.getNonNullServiceDescriptor(this.endpointURI.getSchemeMetaInfo(), this.getOverrides(connector)));
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
    }

    private List getTransformersFromString(String transformers) throws TransportFactoryException {
        try {
            return MuleObjectHelper.getTransformers(transformers, ",");
        }
        catch (MuleException e) {
            throw new TransportFactoryException(e);
        }
    }

    private Properties getOverrides(UMOConnector connector) {
        Map so;
        Properties overrides = new Properties();
        if (connector instanceof AbstractConnector && (so = ((AbstractConnector)connector).getServiceOverrides()) != null) {
            overrides.putAll((Map<?, ?>)so);
        }
        return overrides;
    }

    private TransportServiceDescriptor getNonNullServiceDescriptor(String scheme, Properties overrides) throws ServiceException {
        TransportServiceDescriptor sd = (TransportServiceDescriptor)RegistryContext.getRegistry().lookupServiceDescriptor("transport", scheme, overrides);
        if (null != sd) {
            return sd;
        }
        throw new ServiceException(CoreMessages.noServiceTransportDescriptor(scheme));
    }

    private UMOConnector getConnector(UMOEndpointURI endpointURI, UMOManagementContext managementContext) throws EndpointException {
        UMOConnector connector;
        String scheme = endpointURI.getFullScheme();
        try {
            if (this.getCreateConnector() == 1) {
                connector = TransportFactory.createConnector(endpointURI, managementContext);
                connector.setManagementContext(managementContext);
                managementContext.applyLifecycle(connector);
                managementContext.getRegistry().registerConnector(connector, managementContext);
            } else if (this.getCreateConnector() == 2) {
                connector = TransportFactory.getConnectorByProtocol(scheme);
            } else if (endpointURI.getConnectorName() != null) {
                connector = managementContext.getRegistry().lookupConnector(endpointURI.getConnectorName());
                if (connector == null) {
                    throw new TransportFactoryException(CoreMessages.objectNotRegistered("Connector", endpointURI.getConnectorName()));
                }
            } else {
                connector = TransportFactory.getConnectorByProtocol(scheme);
                if (connector == null) {
                    connector = TransportFactory.createConnector(endpointURI, managementContext);
                    connector.setManagementContext(managementContext);
                    managementContext.applyLifecycle(connector);
                    managementContext.getRegistry().registerConnector(connector, managementContext);
                }
            }
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
        if (connector == null) {
            Message m = CoreMessages.failedToCreateObjectWith("Endpoint", "endpointURI: " + endpointURI);
            m.setNextMessage(CoreMessages.objectIsNull("connector"));
            throw new TransportFactoryException(m);
        }
        return connector;
    }

    public void setConnector(UMOConnector connector) {
        this.connector = connector;
    }

    public void setTransformers(List transformers) {
        this.transformers = transformers;
    }

    public void setResponseTransformers(List responseTransformers) {
        this.responseTransformers = responseTransformers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void setTransactionConfig(UMOTransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public void setFilter(UMOFilter filter) {
        this.filter = filter;
    }

    public void setDeleteUnacceptedMessages(boolean deleteUnacceptedMessages) {
        this.deleteUnacceptedMessages = new Boolean(deleteUnacceptedMessages);
    }

    public void setSecurityFilter(UMOEndpointSecurityFilter securityFilter) {
        this.securityFilter = securityFilter;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = new Boolean(synchronous);
    }

    public void setRemoteSync(boolean remoteSync) {
        this.remoteSync = new Boolean(remoteSync);
    }

    public void setRemoteSyncTimeout(int remoteSyncTimeout) {
        this.remoteSyncTimeout = new Integer(remoteSyncTimeout);
    }

    public void setStreaming(boolean streaming) {
        this.streaming = new Boolean(streaming);
    }

    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    public void setEndpointEncoding(String endpointEncoding) {
        this.endpointEncoding = endpointEncoding;
    }

    public void setCreateConnector(int createConnector) {
        this.createConnector = new Integer(createConnector);
    }

    public void setRegistryId(String registryId) {
        this.registryId = registryId;
    }

    public void setManagementContext(UMOManagementContext managementContext) {
        this.managementContext = managementContext;
    }

    public void setConnectionStrategy(ConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public UMOEndpointURI getEndpointURI() {
        return this.endpointURI;
    }

    public void setEndpointURI(UMOEndpointURI endpointURI) {
        this.endpointURI = endpointURI;
    }
}

