/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.FutureMessageResult;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.transformer.TransformerException;

public class MuleEventContext
implements UMOEventContext {
    protected static final Log logger = LogFactory.getLog((Class)MuleEventContext.class);
    private final UMOEvent event;
    private final UMOSession session;

    MuleEventContext(UMOEvent event) {
        this.event = event;
        this.session = event.getSession();
    }

    public UMOMessage getMessage() {
        return this.event.getMessage();
    }

    public byte[] getMessageAsBytes() throws UMOException {
        return this.event.getMessageAsBytes();
    }

    public Object getTransformedMessage() throws TransformerException {
        return this.event.getTransformedMessage();
    }

    public Object getTransformedMessage(Class expectedType) throws TransformerException {
        Object message = this.getTransformedMessage();
        if (expectedType != null && expectedType.isAssignableFrom(message.getClass())) {
            return message;
        }
        throw new TransformerException(CoreMessages.transformOnObjectNotOfSpecifiedType(this.getComponent().getName(), expectedType), this.event.getEndpoint().getTransformers());
    }

    public byte[] getTransformedMessageAsBytes() throws TransformerException {
        return this.event.getTransformedMessageAsBytes();
    }

    public String getTransformedMessageAsString(String encoding) throws TransformerException {
        return this.event.getTransformedMessageAsString(encoding);
    }

    public String getMessageAsString(String encoding) throws UMOException {
        return this.event.getMessageAsString(encoding);
    }

    public String getTransformedMessageAsString() throws TransformerException {
        return this.event.getTransformedMessageAsString();
    }

    public String getMessageAsString() throws UMOException {
        return this.event.getMessageAsString();
    }

    public UMOTransaction getCurrentTransaction() {
        return TransactionCoordination.getInstance().getTransaction();
    }

    public void markTransactionForRollback() throws TransactionException {
        if (this.getCurrentTransaction() != null) {
            this.getCurrentTransaction().setRollbackOnly();
        }
    }

    public UMOMessage sendEvent(Object message) throws UMOException {
        return this.sendEvent(new MuleMessage(message, this.event.getMessage()));
    }

    public UMOMessage sendEvent(UMOMessage message, UMOImmutableEndpoint endpoint) throws UMOException {
        this.setRemoteSync(message, endpoint);
        return this.session.sendEvent(message, endpoint);
    }

    public UMOMessage sendEvent(UMOMessage message) throws UMOException {
        this.setRemoteSync(message, this.event.getEndpoint());
        return this.session.sendEvent(message);
    }

    public UMOMessage sendEvent(UMOMessage message, UMOEndpointURI endpointUri) throws UMOException {
        UMOImmutableEndpoint endpoint = this.getManagementContext().getRegistry().createEndpoint(endpointUri, "sender", this.getManagementContext());
        this.setRemoteSync(message, endpoint);
        return this.session.sendEvent(message, endpoint);
    }

    public FutureMessageResult sendEventAsync(final Object message, final int timeout) throws UMOException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                MuleMessage umoMessage = new MuleMessage(message, MuleEventContext.this.event.getMessage());
                umoMessage.setBooleanProperty("MULE_REMOTE_SYNC", true);
                umoMessage.setIntProperty("MULE_EVENT_TIMEOUT", timeout);
                return MuleEventContext.this.sendEvent(umoMessage);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable);
        result.execute();
        return result;
    }

    public FutureMessageResult sendEventAsync(final UMOMessage message, final int timeout) throws UMOException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                message.setBooleanProperty("MULE_REMOTE_SYNC", true);
                message.setIntProperty("MULE_EVENT_TIMEOUT", timeout);
                return MuleEventContext.this.sendEvent(message);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable);
        result.execute();
        return result;
    }

    public FutureMessageResult sendEventAsync(final UMOMessage message, final UMOEndpointURI endpointUri, final int timeout) throws UMOException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                message.setBooleanProperty("MULE_REMOTE_SYNC", true);
                message.setIntProperty("MULE_EVENT_TIMEOUT", timeout);
                return MuleEventContext.this.sendEvent(message, endpointUri);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable);
        result.execute();
        return result;
    }

    public FutureMessageResult sendEventAsync(final UMOMessage message, final String endpointName, final int timeout) throws UMOException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                message.setBooleanProperty("MULE_REMOTE_SYNC", true);
                message.setIntProperty("MULE_EVENT_TIMEOUT", timeout);
                return MuleEventContext.this.sendEvent(message, endpointName);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable);
        result.execute();
        return result;
    }

    public UMOMessage sendEvent(UMOMessage message, String endpointName) throws UMOException {
        UMOImmutableEndpoint endpoint = RegistryContext.getRegistry().lookupOutboundEndpoint(endpointName, this.getManagementContext());
        this.setRemoteSync(message, endpoint);
        return this.session.sendEvent(message, endpoint);
    }

    public void dispatchEvent(Object message) throws UMOException {
        this.session.dispatchEvent(new MuleMessage(message, this.event.getMessage()));
    }

    public void dispatchEvent(UMOMessage message) throws UMOException {
        this.session.dispatchEvent(message);
    }

    public void dispatchEvent(UMOMessage message, UMOEndpointURI endpointUri) throws UMOException {
        UMOImmutableEndpoint endpoint = this.getManagementContext().getRegistry().createEndpoint(endpointUri, "sender", this.getManagementContext());
        this.session.dispatchEvent(message, endpoint);
    }

    public void dispatchEvent(UMOMessage message, String endpointName) throws UMOException {
        this.session.dispatchEvent(message, endpointName);
    }

    public void dispatchEvent(UMOMessage message, UMOImmutableEndpoint endpoint) throws UMOException {
        this.session.dispatchEvent(message, endpoint);
    }

    public UMOMessage receiveEvent(UMOImmutableEndpoint endpoint, long timeout) throws UMOException {
        return this.session.receiveEvent(endpoint, timeout);
    }

    public UMOMessage receiveEvent(String endpointName, long timeout) throws UMOException {
        return this.session.receiveEvent(endpointName, timeout);
    }

    public UMOMessage receiveEvent(UMOEndpointURI endpointUri, long timeout) throws UMOException {
        UMOImmutableEndpoint endpoint = this.getManagementContext().getRegistry().createEndpoint(endpointUri, "sender", this.getManagementContext());
        return this.session.receiveEvent(endpoint, timeout);
    }

    public UMOComponent getComponent() {
        return this.event.getComponent();
    }

    public boolean isStopFurtherProcessing() {
        return RequestContext.getEvent().isStopFurtherProcessing();
    }

    public void setStopFurtherProcessing(boolean stopFurtherProcessing) {
        RequestContext.getEvent().setStopFurtherProcessing(stopFurtherProcessing);
    }

    public OutputStream getOutputStream() {
        return this.event.getOutputStream();
    }

    public boolean isSynchronous() {
        return this.event.isSynchronous();
    }

    public UMOEndpointURI getEndpointURI() {
        return this.event.getEndpoint().getEndpointURI();
    }

    public UMOTransaction getTransaction() {
        return TransactionCoordination.getInstance().getTransaction();
    }

    public int getTimeout() {
        return this.event.getTimeout();
    }

    private void setRemoteSync(UMOMessage message, UMOImmutableEndpoint endpoint) {
        if (endpoint.isRemoteSync()) {
            if (this.getTransaction() == null) {
                message.setBooleanProperty("MULE_REMOTE_SYNC", true);
            } else {
                throw new IllegalStateException(CoreMessages.cannotUseTxAndRemoteSync().getMessage());
            }
        }
    }

    public boolean isStreaming() {
        return this.event.getEndpoint().isStreaming();
    }

    public String getEncoding() {
        return this.event.getEncoding();
    }

    public UMOSession getSession() {
        return this.event.getSession();
    }

    public String toString() {
        return this.event.toString();
    }

    public UMOManagementContext getManagementContext() {
        return this.event.getManagementContext();
    }
}

