/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.config.MuleManifest;
import org.mule.providers.AbstractConnector;
import org.mule.providers.ConnectionStrategy;
import org.mule.transformers.TransformerUtils;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransactionConfig;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.security.UMOEndpointSecurityFilter;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassUtils;

public class ImmutableMuleEndpoint
implements UMOImmutableEndpoint {
    private static final long serialVersionUID = -1650380871293160973L;
    protected static final Log logger = LogFactory.getLog((Class)ImmutableMuleEndpoint.class);
    protected UMOConnector connector = null;
    protected UMOEndpointURI endpointUri = null;
    protected AtomicReference transformers = new AtomicReference((Object)TransformerUtils.UNDEFINED);
    protected AtomicReference responseTransformers = new AtomicReference((Object)TransformerUtils.UNDEFINED);
    protected String name = null;
    protected String type;
    protected Map properties = new HashMap();
    protected UMOTransactionConfig transactionConfig = null;
    protected UMOFilter filter = null;
    protected boolean deleteUnacceptedMessages = false;
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected UMOEndpointSecurityFilter securityFilter = null;
    protected Boolean synchronous = null;
    protected Boolean remoteSync = null;
    protected Integer remoteSyncTimeout = null;
    protected boolean streaming = false;
    protected String initialState = "started";
    protected String endpointEncoding;
    protected int createConnector = 0;
    protected String registryId = null;
    protected UMOManagementContext managementContext;
    protected ConnectionStrategy connectionStrategy;

    protected ImmutableMuleEndpoint() {
    }

    public UMOEndpointURI getEndpointURI() {
        return this.endpointUri;
    }

    public String getEncoding() {
        return this.endpointEncoding;
    }

    public String getType() {
        return this.type;
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public String getName() {
        return this.name;
    }

    public List getTransformers() {
        this.lazyInitTransformers();
        return (List)this.transformers.get();
    }

    public Map getProperties() {
        return this.properties;
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        String sanitizedEndPointUri = null;
        URI uri = null;
        if (this.endpointUri != null) {
            sanitizedEndPointUri = this.endpointUri.toString();
            uri = this.endpointUri.getUri();
        }
        if (uri != null && uri.getRawUserInfo() != null && uri.getScheme() != null && uri.getHost() != null && uri.getRawPath() != null) {
            Pattern sanitizerPattern = Pattern.compile("(.*):.*");
            Matcher sanitizerMatcher = sanitizerPattern.matcher(uri.getRawUserInfo());
            if (sanitizerMatcher.matches()) {
                sanitizedEndPointUri = uri.getScheme() + "://" + sanitizerMatcher.group(1) + ":<password>" + "@" + uri.getHost() + uri.getRawPath();
            }
            if (uri.getRawQuery() != null) {
                sanitizedEndPointUri = sanitizedEndPointUri + "?" + uri.getRawQuery();
            }
        }
        return ClassUtils.getClassName(this.getClass()) + "{endpointUri=" + sanitizedEndPointUri + ", connector=" + this.connector + ", transformer=" + this.transformers.get() + ", name='" + this.name + "'" + ", type='" + this.type + "'" + ", properties=" + this.properties + ", transactionConfig=" + this.transactionConfig + ", filter=" + this.filter + ", deleteUnacceptedMessages=" + this.deleteUnacceptedMessages + ", initialised=" + this.initialised + ", securityFilter=" + this.securityFilter + ", synchronous=" + this.synchronous + ", initialState=" + this.initialState + ", createConnector=" + this.createConnector + ", remoteSync=" + this.remoteSync + ", remoteSyncTimeout=" + this.remoteSyncTimeout + ", endpointEncoding=" + this.endpointEncoding + "}";
    }

    public String getProtocol() {
        return this.connector.getProtocol();
    }

    public boolean canReceive() {
        return this.getType().equals("receiver");
    }

    public boolean canSend() {
        return this.getType().equals("sender");
    }

    public UMOTransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableMuleEndpoint)) {
            return false;
        }
        ImmutableMuleEndpoint immutableMuleProviderDescriptor = (ImmutableMuleEndpoint)o;
        if (!this.connector.getName().equals(immutableMuleProviderDescriptor.connector.getName())) {
            return false;
        }
        if (this.endpointUri != null && immutableMuleProviderDescriptor.endpointUri != null ? !this.endpointUri.getAddress().equals(immutableMuleProviderDescriptor.endpointUri.getAddress()) : immutableMuleProviderDescriptor.endpointUri != null) {
            return false;
        }
        if (!this.name.equals(immutableMuleProviderDescriptor.name)) {
            return false;
        }
        return this.getType().equals(immutableMuleProviderDescriptor.getType());
    }

    public int hashCode() {
        int result = this.appendHash(0, this.connector);
        result = this.appendHash(result, this.endpointUri);
        result = this.appendHash(result, this.name);
        result = this.appendHash(result, this.getType());
        return result;
    }

    private int appendHash(int hash, Object component) {
        int delta = component != null ? component.hashCode() : 0;
        return 29 * hash + delta;
    }

    public UMOFilter getFilter() {
        return this.filter;
    }

    public boolean isDeleteUnacceptedMessages() {
        return this.deleteUnacceptedMessages;
    }

    protected void lazyInitTransformers() {
        if (TransformerUtils.isUndefined((List)this.transformers.get())) {
            List newTransformers;
            if (this.connector instanceof AbstractConnector) {
                newTransformers = "sender".equals(this.type) ? ((AbstractConnector)this.connector).getDefaultOutboundTransformers() : ((AbstractConnector)this.connector).getDefaultInboundTransformers();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creating new transformer " + newTransformers + " for endpoint " + this + " of type " + this.type));
                }
            } else {
                newTransformers = TransformerUtils.UNDEFINED;
                logger.warn((Object)("Connector " + this.connector.getName() + " does not inherit AbstractConnector"));
            }
            this.setTransformersIfUndefined(this.transformers, newTransformers);
        }
    }

    protected void setTransformersIfUndefined(AtomicReference reference, List transformers) {
        TransformerUtils.discourageNullTransformers(transformers);
        reference.compareAndSet((Object)TransformerUtils.UNDEFINED, (Object)transformers);
        this.updateTransformerEndpoints(reference);
    }

    protected void updateTransformerEndpoints(AtomicReference reference) {
        List transformers = (List)reference.get();
        if (TransformerUtils.isDefined(transformers)) {
            Iterator transformer = transformers.iterator();
            while (transformer.hasNext()) {
                ((UMOTransformer)transformer.next()).setEndpoint(this);
            }
        }
    }

    public UMOEndpointSecurityFilter getSecurityFilter() {
        return this.securityFilter;
    }

    public boolean isSynchronous() {
        if (this.synchronous == null) {
            return RegistryContext.getConfiguration().isDefaultSynchronousEndpoints();
        }
        return this.synchronous;
    }

    public boolean isSynchronousSet() {
        return this.synchronous != null;
    }

    public int getCreateConnector() {
        return this.createConnector;
    }

    public boolean isRemoteSync() {
        if (this.remoteSync == null) {
            this.remoteSync = this.connector == null || this.connector.isRemoteSyncEnabled() ? Boolean.FALSE : Boolean.FALSE;
        }
        return this.remoteSync;
    }

    public int getRemoteSyncTimeout() {
        if (this.remoteSyncTimeout == null) {
            this.remoteSyncTimeout = new Integer(0);
        }
        return this.remoteSyncTimeout;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public List getResponseTransformers() {
        return (List)this.responseTransformers.get();
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public Object getProperty(Object key) {
        Object value = this.properties.get(key);
        if (value == null) {
            value = this.endpointUri.getParams().get(key);
        }
        return value;
    }

    public void dispatch(UMOEvent event) throws DispatchException {
        if (this.connector == null) {
            throw new IllegalStateException("The connector on the endpoint: " + this.toString() + " is null. Please contact " + MuleManifest.getDevListEmail());
        }
        this.connector.dispatch(this, event);
    }

    public UMOMessage receive(long timeout) throws Exception {
        if (this.connector != null) {
            return this.connector.receive(this, timeout);
        }
        throw new IllegalStateException("The connector on the endpoint: " + this.toString() + " is null. Please contact " + MuleManifest.getDevListEmail());
    }

    public UMOMessage send(UMOEvent event) throws DispatchException {
        if (this.connector != null) {
            return this.connector.send(this, event);
        }
        throw new IllegalStateException("The connector on the endpoint: " + this.toString() + " is null. Please contact " + MuleManifest.getDevListEmail());
    }

    public UMOManagementContext getManagementContext() {
        return this.managementContext;
    }

    public ConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public void initialise() throws InitialisationException {
    }
}

