/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.impl.NoSatisfiableMethodsException;
import org.mule.impl.RequestContext;
import org.mule.impl.TooManySatisfiableMethodsException;
import org.mule.impl.UMOComponentAware;
import org.mule.impl.VoidResult;
import org.mule.impl.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.routing.nested.NestedInvocationHandler;
import org.mule.umo.ComponentException;
import org.mule.umo.Invocation;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.Startable;
import org.mule.umo.lifecycle.Stoppable;
import org.mule.umo.lifecycle.UMOLifecycleAdapter;
import org.mule.umo.model.UMOEntryPointResolverSet;
import org.mule.umo.routing.UMONestedRouter;
import org.mule.util.ClassUtils;

public class DefaultLifecycleAdapter
implements UMOLifecycleAdapter {
    protected static final Log logger = LogFactory.getLog((Class)DefaultLifecycleAdapter.class);
    private Object pojoService;
    private UMOComponent component;
    private boolean isStoppable = false;
    private boolean isStartable = false;
    private boolean isDisposable = false;
    private boolean started = false;
    private boolean disposed = false;
    private UMOEntryPointResolverSet entryPointResolver;

    public DefaultLifecycleAdapter(Object pojoService, UMOComponent component) throws UMOException {
        this(pojoService, component, new LegacyEntryPointResolverSet());
    }

    public DefaultLifecycleAdapter(Object pojoService, UMOComponent component, UMOEntryPointResolverSet epResolver) throws UMOException {
        this.initialise(pojoService, component, epResolver);
    }

    protected void initialise(Object pojoService, UMOComponent component, UMOEntryPointResolverSet entryPointResolver) throws UMOException {
        if (pojoService == null) {
            throw new IllegalArgumentException("POJO Service cannot be null");
        }
        if (entryPointResolver == null) {
            entryPointResolver = new LegacyEntryPointResolverSet();
        }
        this.pojoService = pojoService;
        this.component = component;
        this.entryPointResolver = entryPointResolver;
        this.isStartable = Startable.class.isInstance(component);
        this.isStoppable = Stoppable.class.isInstance(component);
        this.isDisposable = Disposable.class.isInstance(component);
        if (pojoService instanceof UMOComponentAware) {
            ((UMOComponentAware)pojoService).setComponent(component);
        }
        this.configureNestedRouter();
    }

    public void start() throws UMOException {
        if (this.isStartable) {
            try {
                this.component.start();
            }
            catch (Exception e) {
                throw new MuleException(CoreMessages.failedToStart("UMO Component: " + this.component.getName()), (Throwable)e);
            }
        }
        this.started = true;
    }

    public void stop() throws UMOException {
        if (this.isStoppable) {
            try {
                this.component.stop();
            }
            catch (Exception e) {
                throw new MuleException(CoreMessages.failedToStop("UMO Component: " + this.component.getName()), (Throwable)e);
            }
        }
        this.started = false;
    }

    public void dispose() {
        if (this.isDisposable) {
            try {
                this.component.dispose();
            }
            catch (Exception e) {
                logger.error((Object)("failed to dispose: " + this.component.getName()), (Throwable)e);
            }
        }
        this.disposed = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void handleException(Object message, Exception e) {
        this.component.getExceptionListener().exceptionThrown(e);
    }

    public UMOMessage intercept(Invocation invocation) throws UMOException {
        Object result;
        UMOEvent event = RequestContext.getEvent();
        try {
            result = this.component.getEntryPointResolverSet() != null ? this.component.getEntryPointResolverSet().invoke(this.pojoService, RequestContext.getEventContext()) : this.entryPointResolver.invoke(this.pojoService, RequestContext.getEventContext());
        }
        catch (Exception e) {
            throw new ComponentException(RequestContext.getEventContext().getMessage(), this.component, (Throwable)e);
        }
        UMOMessage resultMessage = null;
        if (result instanceof VoidResult) {
            resultMessage = new MuleMessage(event.getTransformedMessage(), RequestContext.getEventContext().getMessage());
        } else if (result != null) {
            resultMessage = result instanceof UMOMessage ? (UMOMessage)result : new MuleMessage(result, event.getMessage());
        }
        return resultMessage;
    }

    public void initialise() throws InitialisationException {
        if (Initialisable.class.isInstance(this.component)) {
            this.component.initialise();
        }
    }

    protected void configureNestedRouter() throws UMOException {
        if (this.component.getNestedRouter() != null) {
            HashMap bindings = new HashMap();
            Iterator it = this.component.getNestedRouter().getRouters().iterator();
            while (it.hasNext()) {
                UMONestedRouter nestedRouter = (UMONestedRouter)it.next();
                Object proxy = bindings.get(nestedRouter.getInterface());
                if (proxy == null) {
                    proxy = nestedRouter.createProxy(this.pojoService);
                    bindings.put(nestedRouter.getInterface(), proxy);
                    List methods = ClassUtils.getSatisfiableMethods(this.pojoService.getClass(), new Class[]{nestedRouter.getInterface()}, true, false, null);
                    if (methods.size() != 1) {
                        if (methods.size() > 1) {
                            throw new TooManySatisfiableMethodsException(this.pojoService.getClass(), new Class[]{nestedRouter.getInterface()});
                        }
                        throw new NoSatisfiableMethodsException(this.pojoService.getClass(), new Class[]{nestedRouter.getInterface()});
                    }
                    Method setterMethod = (Method)methods.get(0);
                    try {
                        setterMethod.invoke(this.pojoService, proxy);
                        continue;
                    }
                    catch (Exception e) {
                        throw new InitialisationException(CoreMessages.failedToSetProxyOnService(nestedRouter, this.pojoService.getClass()), (Throwable)e, this);
                    }
                }
                NestedInvocationHandler handler = (NestedInvocationHandler)Proxy.getInvocationHandler(proxy);
                handler.addRouterForInterface(nestedRouter);
            }
        }
    }

    public UMOComponent getComponent() {
        return this.component;
    }
}

