/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.beans.ExceptionListener;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.ManagementContextAware;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.MuleSessionHandler;
import org.mule.impl.RequestContext;
import org.mule.impl.internal.notifications.ExceptionNotification;
import org.mule.impl.message.ExceptionMessage;
import org.mule.providers.NullPayload;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.MessagingException;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.InvalidEndpointTypeException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.routing.RoutingException;

public abstract class AbstractExceptionListener
implements ExceptionListener,
Initialisable,
Disposable,
ManagementContextAware {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected List endpoints = new CopyOnWriteArrayList();
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected UMOManagementContext managementContext;

    public void setManagementContext(UMOManagementContext context) {
        this.managementContext = context;
    }

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List endpoints) {
        this.endpoints.clear();
        Iterator iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            this.addEndpoint((UMOImmutableEndpoint)iterator.next());
        }
    }

    public void addEndpoint(UMOImmutableEndpoint endpoint) {
        if (endpoint != null) {
            if (!endpoint.canSend()) {
                throw new InvalidEndpointTypeException(CoreMessages.exceptionListenerMustUseOutboundEndpoint(this, endpoint));
            }
            this.endpoints.add(endpoint);
        }
    }

    public boolean removeEndpoint(UMOImmutableEndpoint endpoint) {
        return this.endpoints.remove(endpoint);
    }

    public void exceptionThrown(Exception e) {
        this.fireNotification(new ExceptionNotification(e));
        this.logException(e);
        Throwable t = this.getExceptionType(e, RoutingException.class);
        if (t != null) {
            RoutingException re = (RoutingException)t;
            this.handleRoutingException(re.getUmoMessage(), re.getEndpoint(), e);
            return;
        }
        t = this.getExceptionType(e, MessagingException.class);
        if (t != null) {
            MessagingException me = (MessagingException)t;
            this.handleMessagingException(me.getUmoMessage(), e);
            return;
        }
        t = this.getExceptionType(e, LifecycleException.class);
        if (t != null) {
            LifecycleException le = (LifecycleException)t;
            this.handleLifecycleException(le.getComponent(), e);
            if (RequestContext.getEventContext() != null) {
                this.handleMessagingException(RequestContext.getEventContext().getMessage(), e);
            } else {
                this.logger.info((Object)"There is no current event available, routing Null message with the exception");
                this.handleMessagingException(new MuleMessage(NullPayload.getInstance()), e);
            }
            return;
        }
        this.handleStandardException(e);
    }

    protected Throwable getExceptionType(Throwable t, Class exceptionType) {
        while (t != null) {
            if (exceptionType.isAssignableFrom(t.getClass())) {
                return t;
            }
            t = t.getCause();
        }
        return null;
    }

    public final synchronized void initialise() throws InitialisationException {
        if (!this.initialised.get()) {
            this.doInitialise(this.managementContext);
            this.initialised.set(true);
        }
    }

    protected void doInitialise(UMOManagementContext managementContext) throws InitialisationException {
        this.logger.info((Object)("Initialising exception listener: " + this.toString()));
        Iterator iterator = this.endpoints.iterator();
        while (iterator.hasNext()) {
            UMOEndpoint umoEndpoint = (UMOEndpoint)iterator.next();
            umoEndpoint.initialise();
        }
    }

    protected void markTransactionForRollback() {
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        try {
            if (tx != null) {
                tx.setRollbackOnly();
            }
        }
        catch (TransactionException e) {
            this.logException(e);
        }
    }

    protected void routeException(UMOMessage message, UMOImmutableEndpoint failedEndpoint, Throwable t) {
        UMOImmutableEndpoint endpoint = this.getEndpoint(t);
        if (endpoint != null) {
            try {
                this.logger.error((Object)("Message being processed is: " + (message == null ? "null" : message.toString())));
                UMOEventContext ctx = RequestContext.getEventContext();
                String component = "Unknown";
                UMOEndpointURI endpointUri = null;
                if (ctx != null) {
                    if (ctx.getComponent() != null) {
                        component = ctx.getComponent().getName();
                    }
                    endpointUri = ctx.getEndpointURI();
                } else if (failedEndpoint != null) {
                    endpointUri = failedEndpoint.getEndpointURI();
                }
                ExceptionMessage msg = new ExceptionMessage(this.getErrorMessagePayload(message), t, component, endpointUri);
                MuleMessage exceptionMessage = ctx == null ? new MuleMessage(msg) : new MuleMessage((Object)msg, ctx.getMessage());
                UMOEvent exceptionEvent = new MuleEvent((UMOMessage)exceptionMessage, endpoint, new MuleSession(exceptionMessage, new MuleSessionHandler()), true);
                exceptionEvent = RequestContext.setEvent(exceptionEvent);
                endpoint.send(exceptionEvent);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("routed Exception message via " + endpoint));
                }
            }
            catch (UMOException e) {
                this.logFatal(message, e);
            }
        } else {
            this.markTransactionForRollback();
        }
    }

    protected Object getErrorMessagePayload(UMOMessage message) {
        try {
            return message.getPayloadAsString();
        }
        catch (Exception e) {
            this.logException(e);
            this.logger.info((Object)"Failed to read message payload as string, using raw payload");
            return message.getPayload();
        }
    }

    protected UMOImmutableEndpoint getEndpoint(Throwable t) {
        if (this.endpoints.size() > 0) {
            return (UMOImmutableEndpoint)this.endpoints.get(0);
        }
        return null;
    }

    protected void logException(Throwable t) {
        UMOException umoe = ExceptionHelper.getRootMuleException(t);
        if (umoe != null) {
            this.logger.error((Object)umoe.getDetailedMessage());
        } else {
            this.logger.error((Object)("Caught exception in Exception Strategy: " + t.getMessage()), t);
        }
    }

    protected void logFatal(UMOMessage message, Throwable t) {
        this.logger.fatal((Object)("Failed to dispatch message to error queue after it failed to process.  This may cause message loss." + (message == null ? "" : "Logging Message here: \n" + message.toString())), t);
    }

    public boolean isInitialised() {
        return this.initialised.get();
    }

    public void dispose() {
    }

    protected void fireNotification(ExceptionNotification notification) {
        if (this.managementContext != null) {
            this.managementContext.fireNotification(notification);
        }
    }

    public abstract void handleMessagingException(UMOMessage var1, Throwable var2);

    public abstract void handleRoutingException(UMOMessage var1, UMOImmutableEndpoint var2, Throwable var3);

    public abstract void handleLifecycleException(Object var1, Throwable var2);

    public abstract void handleStandardException(Throwable var1);
}

