/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific.endpoint;

import org.mule.config.spring.parsers.AbstractChildDefinitionParser;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class UnaddressedEndpointDefinitionParser
extends AbstractChildDefinitionParser {
    public static final String ENDPOINT_URI_ATTRIBUTE = "endpointURI";
    public static final String ADDRESS_ATTRIBUTE = "address";
    private Class endpointClass;

    public UnaddressedEndpointDefinitionParser(Class endpointClass) {
        this.endpointClass = endpointClass;
        this.addAlias(ADDRESS_ATTRIBUTE, ENDPOINT_URI_ATTRIBUTE);
        this.addMapping("createConnector", "GET_OR_CREATE=0,ALWAYS_CREATE=1,NEVER_CREATE=2");
        this.addIgnored("ref");
    }

    public String getPropertyName(Element element) {
        if (this.isGlobal(element)) {
            return null;
        }
        return "endpoint";
    }

    protected boolean isGlobal(Element element) {
        return this.isTopLevel(element);
    }

    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (StringUtils.isNotBlank((String)element.getAttribute("connector"))) {
            builder.addDependsOn(element.getAttribute("connector"));
        }
        this.processTransformerDependencies(builder, element, "transformers");
        this.processTransformerDependencies(builder, element, "responseTransformers");
        super.parseChild(element, parserContext, builder);
    }

    protected void processTransformerDependencies(BeanDefinitionBuilder builder, Element element, String attributeName) {
        if (StringUtils.isNotBlank((String)element.getAttribute(attributeName))) {
            String[] trans = StringUtils.split((String)element.getAttribute(attributeName), (String)" ,;");
            for (int i = 0; i < trans.length; ++i) {
                builder.addDependsOn(trans[i]);
            }
        }
    }

    protected Class getBeanClass(Element element) {
        return this.endpointClass;
    }

    protected BeanDefinitionBuilder createBeanDefinitionBuilder(Element element, Class beanClass) {
        if (null == element.getAttributeNode("ref")) {
            return super.createBeanDefinitionBuilder(element, beanClass);
        }
        String parent = element.getAttribute("ref");
        BeanDefinitionBuilder bdb = BeanDefinitionBuilder.childBeanDefinition((String)parent);
        bdb.getBeanDefinition().setBeanClassName(beanClass.getName());
        return bdb;
    }

    protected String generateChildBeanName(Element e) {
        if (null != e.getAttributeNode("ref")) {
            return "ref:" + e.getAttribute("ref");
        }
        return super.generateChildBeanName(e);
    }

    protected BeanAssembler getBeanAssembler(Element element, BeanDefinitionBuilder bean) {
        if (this.isGlobal(element)) {
            return this.getOrphanBeanAssembler(element, bean);
        }
        return super.getBeanAssembler(element, bean);
    }

    protected void preProcess(Element element) {
        super.preProcess(element);
        AutoIdUtils.ensureUniqueId(element, "endpoint");
    }
}

