/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.mule.config.spring.parsers.specific.ObjectFactoryDefinitionParser;
import org.mule.impl.UMOComponentAware;
import org.mule.util.ClassUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class PojoServiceDefinitionParser
extends ObjectFactoryDefinitionParser {
    public PojoServiceDefinitionParser(Class beanClass) {
        super(beanClass, "serviceFactory");
    }

    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.parseChild(element, parserContext, builder);
        try {
            MutablePropertyValues beanProperties = builder.getBeanDefinition().getPropertyValues();
            Class objectClass = null;
            if (beanProperties.getPropertyValue("objectClass") != null) {
                objectClass = (Class)beanProperties.getPropertyValue("objectClass").getValue();
            }
            if (objectClass == null && beanProperties.getPropertyValue("objectClassName") != null) {
                String objectClassName = (String)beanProperties.getPropertyValue("objectClassName").getValue();
                objectClass = ClassUtils.getClass((String)objectClassName);
            }
            if (UMOComponentAware.class.isAssignableFrom(objectClass)) {
                this.logger.debug((Object)("Injecting UMOComponent into class " + objectClass + " which implements the UMOComponentAware interface."));
                Element parent = (Element)element.getParentNode();
                String componentName = parent.getAttribute("name");
                builder.addPropertyReference("component", componentName);
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)e);
        }
    }
}

