/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.net.URI;
import java.util.Properties;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;

public class LazyEndpointURI
implements UMOEndpointURI {
    private static final String DOTS_SLASHES = "://";
    public static final String ADDRESS = "address";
    public static final String[] ATTRIBUTES = new String[]{"protocol", "username", "password", "hostname", "address", "port", "path"};
    private String address;
    private String protocol;
    private String username;
    private String password;
    private String hostname;
    private Integer port;
    private String path;
    private AtomicReference delegate = new AtomicReference();

    public void setUsername(String username) {
        this.assertNotYetInjected();
        this.username = username;
    }

    public void setPassword(String password) {
        this.assertNotYetInjected();
        this.password = password;
    }

    public void setHostname(String hostname) {
        this.assertNotYetInjected();
        this.hostname = hostname;
    }

    public void setAddress(String address) {
        this.assertNotYetInjected();
        this.address = address;
    }

    public void setPort(int port) {
        this.assertNotYetInjected();
        this.port = new Integer(port);
    }

    public void setProtocol(String protocol) {
        this.assertNotYetInjected();
        this.protocol = protocol;
    }

    public void setPath(String path) {
        this.assertNotYetInjected();
        this.path = path;
    }

    public String toString() {
        if (null != this.address) {
            return this.address;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.protocol);
        buffer.append(DOTS_SLASHES);
        if (null != this.username) {
            buffer.append(this.username);
            if (null != this.password) {
                buffer.append(":");
                buffer.append(this.password);
            }
            buffer.append("@");
        }
        if (null != this.hostname) {
            buffer.append(this.hostname);
            if (null != this.port) {
                buffer.append(":");
                buffer.append(this.port);
            }
        }
        if (null != this.path) {
            if (buffer.length() > DOTS_SLASHES.length()) {
                buffer.append("/");
            }
            buffer.append(this.path);
        }
        return buffer.toString();
    }

    protected void assertNotYetInjected() {
        if (null != this.delegate.get()) {
            throw new IllegalStateException("Too late to set values now!");
        }
    }

    protected UMOEndpointURI lazyDelegate() {
        UMOEndpointURI exists = (UMOEndpointURI)this.delegate.get();
        if (null != exists) {
            return exists;
        }
        try {
            this.delegate.compareAndSet(null, (Object)new MuleEndpointURI(this.toString()));
        }
        catch (EndpointException e) {
            throw (IllegalStateException)new IllegalStateException("Bad address").initCause(e);
        }
        return this.lazyDelegate();
    }

    public String getAddress() {
        return this.lazyDelegate().getAddress();
    }

    public String getFilterAddress() {
        return this.lazyDelegate().getFilterAddress();
    }

    public String getEndpointName() {
        return this.lazyDelegate().getEndpointName();
    }

    public void setEndpointName(String name) {
        throw new UnsupportedOperationException("EndpointAddress.setEdpointName");
    }

    public Properties getParams() {
        return this.lazyDelegate().getParams();
    }

    public Properties getUserParams() {
        return this.lazyDelegate().getUserParams();
    }

    public String getScheme() {
        return this.lazyDelegate().getScheme();
    }

    public String getSchemeMetaInfo() {
        return this.lazyDelegate().getSchemeMetaInfo();
    }

    public String getFullScheme() {
        return this.lazyDelegate().getFullScheme();
    }

    public String getAuthority() {
        return this.lazyDelegate().getAuthority();
    }

    public String getHost() {
        return this.lazyDelegate().getHost();
    }

    public int getPort() {
        return this.lazyDelegate().getPort();
    }

    public String getPath() {
        return this.lazyDelegate().getPath();
    }

    public String getQuery() {
        return this.lazyDelegate().getQuery();
    }

    public String getUserInfo() {
        return this.lazyDelegate().getUserInfo();
    }

    public String getTransformers() {
        return this.lazyDelegate().getTransformers();
    }

    public String getResponseTransformers() {
        return this.lazyDelegate().getResponseTransformers();
    }

    public int getCreateConnector() {
        return this.lazyDelegate().getCreateConnector();
    }

    public URI getUri() {
        return this.lazyDelegate().getUri();
    }

    public String getConnectorName() {
        return this.lazyDelegate().getConnectorName();
    }

    public String getResourceInfo() {
        return this.lazyDelegate().getResourceInfo();
    }

    public String getUsername() {
        return this.lazyDelegate().getUsername();
    }

    public String getPassword() {
        return this.lazyDelegate().getPassword();
    }

    public void initialise() throws InitialisationException {
        this.lazyDelegate().initialise();
    }
}

