/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.delegate;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mule.config.spring.parsers.MuleDefinitionParser;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.PropertyConfiguration;
import org.mule.config.spring.parsers.delegate.AbstractDelegatingDefinitionParser;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractSerialDelegatingDefinitionParser
extends AbstractDelegatingDefinitionParser {
    private int index = 0;
    private boolean first;
    private String originalId;
    private String originalName;
    private Set handledExceptions = new HashSet();

    public AbstractBeanDefinition parseDelegate(Element element, ParserContext parserContext) {
        if (this.index == 0 || this.index >= this.size()) {
            this.first = true;
            this.index = 0;
        } else {
            this.first = false;
        }
        AbstractBeanDefinition bean = null;
        while (null == bean && this.index < this.size()) {
            try {
                MuleDefinitionParser parser = this.getDelegate(this.index);
                bean = this.doSingleBean(this.index++, parser, element, parserContext);
            }
            catch (RuntimeException e) {
                if (this.handledExceptions.contains(e.getClass())) {
                    bean = null;
                    continue;
                }
                throw e;
            }
        }
        if (null != bean) {
            if (this.index == this.size()) {
                bean.removeAttribute("org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_REPEAT_PARSE");
            } else {
                bean.setAttribute("org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_REPEAT_PARSE", (Object)Boolean.TRUE);
            }
        }
        return bean;
    }

    protected AbstractBeanDefinition doSingleBean(int index, MuleDefinitionParser parser, Element element, ParserContext parserContext) {
        return parser.parseDelegate(element, parserContext);
    }

    protected MuleDefinitionParser addDelegate(MuleDefinitionParser delegate) {
        delegate.registerPreProcessor(new PreProcessor(){

            public void preProcess(PropertyConfiguration config, Element element) {
                if (AbstractSerialDelegatingDefinitionParser.this.first) {
                    AbstractSerialDelegatingDefinitionParser.this.originalId = element.getAttribute("id");
                    AbstractSerialDelegatingDefinitionParser.this.originalName = element.getAttribute("name");
                } else {
                    AbstractSerialDelegatingDefinitionParser.this.resetNameAndId(element);
                }
            }
        });
        return super.addDelegate(delegate);
    }

    protected void resetNameAndId(Element element) {
        this.resetAttribute(element, "id", this.originalId);
        this.resetAttribute(element, "name", this.originalName);
    }

    protected void resetAttribute(Element element, String name, String value) {
        if (StringUtils.isEmpty((String)value)) {
            if (element.hasAttribute(name)) {
                element.removeAttribute(name);
            }
        } else {
            element.setAttribute(name, value);
        }
    }

    protected void addHandledException(Class exception) {
        this.handledExceptions.add(exception);
    }

    public static void enableAttributes(MuleDefinitionParser delegate, String[] attributes, boolean enable) {
        delegate.setIgnoredDefault(enable);
        Iterator names = Arrays.asList((Object[])attributes).iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            if (enable) {
                delegate.removeIgnored(name);
                continue;
            }
            delegate.addIgnored(name);
        }
    }

    public static void enableAttributes(MuleDefinitionParser delegate, String[] attributes) {
        AbstractSerialDelegatingDefinitionParser.enableAttributes(delegate, attributes, true);
    }

    public static void disableAttributes(MuleDefinitionParser delegate, String[] attributes) {
        AbstractSerialDelegatingDefinitionParser.enableAttributes(delegate, attributes, false);
    }
}

