/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.assembly;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.assembly.PropertyConfiguration;
import org.mule.config.spring.parsers.assembly.SingleProperty;
import org.mule.config.spring.parsers.assembly.SinglePropertyLiteral;
import org.mule.config.spring.parsers.collection.ChildListEntryDefinitionParser;
import org.mule.config.spring.parsers.collection.ChildMapEntryDefinitionParser;
import org.mule.util.ClassUtils;
import org.mule.util.CoreXMLUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.w3c.dom.Attr;

public class DefaultBeanAssembler
implements BeanAssembler {
    private static Log logger = LogFactory.getLog((Class)DefaultBeanAssembler.class);
    private PropertyConfiguration beanConfig;
    private BeanDefinitionBuilder bean;
    private PropertyConfiguration targetConfig;
    private BeanDefinition target;

    public DefaultBeanAssembler(PropertyConfiguration beanConfig, BeanDefinitionBuilder bean, PropertyConfiguration targetConfig, BeanDefinition target) {
        this.beanConfig = beanConfig;
        this.bean = bean;
        this.targetConfig = targetConfig;
        this.target = target;
    }

    public BeanDefinitionBuilder getBean() {
        return this.bean;
    }

    public BeanDefinition getTarget() {
        return this.target;
    }

    protected PropertyConfiguration getBeanConfig() {
        return this.beanConfig;
    }

    protected PropertyConfiguration getTargetConfig() {
        return this.targetConfig;
    }

    public void extendBean(Attr attribute) {
        String oldName = CoreXMLUtils.attributeName(attribute);
        if (!this.beanConfig.isIgnored(oldName)) {
            logger.debug((Object)(attribute + " for " + this.bean.getBeanDefinition().getBeanClassName()));
            String oldValue = attribute.getNodeValue();
            String newName = DefaultBeanAssembler.bestGuessName(this.beanConfig, oldName, this.bean.getBeanDefinition().getBeanClassName());
            String newValue = this.beanConfig.translateValue(oldName, oldValue);
            this.addPropertyWithReference(this.bean.getBeanDefinition().getPropertyValues(), this.beanConfig.getSingleProperty(oldName), newName, newValue);
        }
    }

    public void extendBean(String newName, Object newValue, boolean isReference) {
        this.addPropertyWithReference(this.bean.getBeanDefinition().getPropertyValues(), new SinglePropertyLiteral(isReference), newName, newValue);
    }

    public void extendTarget(Attr attribute) {
        String oldName = CoreXMLUtils.attributeName(attribute);
        String oldValue = attribute.getNodeValue();
        String newName = DefaultBeanAssembler.bestGuessName(this.targetConfig, oldName, this.bean.getBeanDefinition().getBeanClassName());
        String newValue = this.targetConfig.translateValue(oldName, oldValue);
        this.addPropertyWithReference(this.target.getPropertyValues(), this.targetConfig.getSingleProperty(oldName), newName, newValue);
    }

    public void extendTarget(String newName, Object newValue, boolean isReference) {
        this.assertTargetPresent();
        this.addPropertyWithReference(this.target.getPropertyValues(), new SinglePropertyLiteral(isReference), newName, newValue);
    }

    public void insertBeanInTarget(String oldName) {
        logger.debug((Object)("insert " + this.bean.getBeanDefinition().getBeanClassName() + " -> " + this.target.getBeanClassName()));
        this.assertTargetPresent();
        String newName = DefaultBeanAssembler.bestGuessName(this.targetConfig, oldName, this.target.getBeanClassName());
        Object source = this.bean.getBeanDefinition().getSource();
        PropertyValue pv = this.target.getPropertyValues().getPropertyValue(newName);
        if (!this.targetConfig.isIgnored(oldName)) {
            if (source instanceof ChildMapEntryDefinitionParser.KeyValuePair) {
                if (pv == null) {
                    pv = new PropertyValue(newName, (Object)new ManagedMap());
                }
                ChildMapEntryDefinitionParser.KeyValuePair pair = (ChildMapEntryDefinitionParser.KeyValuePair)source;
                ((Map)pv.getValue()).put(pair.getKey(), pair.getValue());
            } else if (this.targetConfig.isCollection(oldName) || source instanceof ChildListEntryDefinitionParser.ListEntry) {
                if (pv == null) {
                    pv = new PropertyValue(newName, (Object)new ManagedList());
                }
                List list = (List)pv.getValue();
                if (source instanceof ChildListEntryDefinitionParser.ListEntry) {
                    ChildListEntryDefinitionParser.ListEntry entry = (ChildListEntryDefinitionParser.ListEntry)source;
                    list.add(entry.getProxiedObject());
                } else {
                    list.add(this.bean.getBeanDefinition());
                }
            } else {
                pv = new PropertyValue(newName, (Object)this.bean.getBeanDefinition());
            }
            this.target.getPropertyValues().addPropertyValue(pv);
        }
    }

    public void copyBeanToTarget() {
        logger.debug((Object)("copy " + this.bean.getBeanDefinition().getBeanClassName() + " -> " + this.target.getBeanClassName()));
        this.assertTargetPresent();
        MutablePropertyValues targetProperties = this.target.getPropertyValues();
        MutablePropertyValues beanProperties = this.bean.getBeanDefinition().getPropertyValues();
        for (int i = 0; i < beanProperties.size(); ++i) {
            PropertyValue propertyValue = beanProperties.getPropertyValues()[i];
            this.addPropertyWithoutReference(targetProperties, new SinglePropertyLiteral(), propertyValue.getName(), propertyValue.getValue());
        }
    }

    public void setBeanFlag(String flag) {
        MuleHierarchicalBeanDefinitionParserDelegate.setFlag((BeanDefinition)this.bean.getRawBeanDefinition(), flag);
    }

    protected void assertTargetPresent() {
        if (null == this.target) {
            throw new IllegalStateException("Bean assembler does not have a target");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addPropertyWithReference(MutablePropertyValues properties, SingleProperty config, String name, Object value) {
        if (config.isIgnored()) return;
        if (config.isReference()) {
            if (!(value instanceof String)) throw new IllegalArgumentException("Bean reference must be a String: " + name + "/" + value);
            if (((String)value).trim().indexOf(" ") > -1) {
                config.setCollection();
            }
            StringTokenizer ref = new StringTokenizer((String)value);
            while (ref.hasMoreTokens()) {
                this.addPropertyWithoutReference(properties, config, name, new RuntimeBeanReference(ref.nextToken()));
            }
            return;
        } else {
            this.addPropertyWithoutReference(properties, config, name, value);
        }
    }

    protected void addPropertyWithoutReference(MutablePropertyValues properties, SingleProperty config, String name, Object value) {
        if (!config.isIgnored()) {
            logger.debug((Object)(name + ": " + value));
            Object oldValue = null;
            if (properties.contains(name)) {
                oldValue = properties.getPropertyValue(name).getValue();
            }
            if (config.isCollection() || oldValue instanceof Collection || value instanceof Collection) {
                ManagedList values = new ManagedList();
                if (null != oldValue) {
                    properties.removePropertyValue(name);
                    if (oldValue instanceof Collection) {
                        values.addAll((Collection)oldValue);
                    } else {
                        values.add(oldValue);
                    }
                }
                if (value instanceof Collection) {
                    values.addAll((Collection)value);
                } else {
                    values.add(value);
                }
                properties.addPropertyValue(name, (Object)values);
            } else {
                properties.addPropertyValue(name, value);
            }
        }
    }

    protected static String bestGuessName(PropertyConfiguration config, String oldName, String className) {
        String newName = config.translateName(oldName);
        if (!DefaultBeanAssembler.methodExists(className, newName)) {
            String pluraly;
            String plural = newName + "s";
            if (DefaultBeanAssembler.methodExists(className, plural)) {
                config.addCollection(oldName);
                return plural;
            }
            if (newName.endsWith("y") && DefaultBeanAssembler.methodExists(className, pluraly = newName.substring(0, newName.length() - 1) + "ies")) {
                config.addCollection(oldName);
                return pluraly;
            }
        }
        return newName;
    }

    protected static boolean methodExists(String className, String newName) {
        try {
            Class clazz = ClassUtils.getClass((String)className);
            Method[] methods = clazz.getMethods();
            String setter = "set" + newName;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equalsIgnoreCase(setter)) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.debug((Object)("Could not access bean class " + className), (Throwable)e);
        }
        return false;
    }
}

