/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.spring.parsers.MuleDefinitionParser;
import org.mule.config.spring.parsers.PostProcessor;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.assembly.BeanAssemblerFactory;
import org.mule.config.spring.parsers.assembly.DefaultBeanAssemblerFactory;
import org.mule.config.spring.parsers.assembly.ReusablePropertyConfiguration;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class AbstractMuleBeanDefinitionParser
extends AbstractBeanDefinitionParser
implements MuleDefinitionParser {
    public static final String ROOT_ELEMENT = "mule";
    public static final String ROOT_UNSAFE_ELEMENT = "mule-unsafe";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_CLASS = "class";
    public static final String ATTRIBUTE_REF = "ref";
    public static final String ATTRIBUTE_REF_SUFFIX = "-ref";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private BeanAssemblerFactory beanAssemblerFactory = new DefaultBeanAssemblerFactory();
    protected ReusablePropertyConfiguration beanPropertyConfiguration = new ReusablePropertyConfiguration();
    private ParserContext parserContext;
    private BeanDefinitionRegistry registry;
    private LinkedList preProcessors = new LinkedList();
    private List postProcessors = new LinkedList();
    protected boolean singleton = false;
    private boolean allowClassAttribute = true;
    private Class classConstraint = null;

    public AbstractMuleBeanDefinitionParser() {
        this.addIgnored(ATTRIBUTE_ID);
    }

    public MuleDefinitionParser addReference(String propertyName) {
        this.beanPropertyConfiguration.addReference(propertyName);
        return this;
    }

    public MuleDefinitionParser addMapping(String propertyName, Map mappings) {
        this.beanPropertyConfiguration.addMapping(propertyName, mappings);
        return this;
    }

    public MuleDefinitionParser addMapping(String propertyName, String mappings) {
        this.beanPropertyConfiguration.addMapping(propertyName, mappings);
        return this;
    }

    public MuleDefinitionParser addAlias(String alias, String propertyName) {
        this.beanPropertyConfiguration.addAlias(alias, propertyName);
        return this;
    }

    public MuleDefinitionParser addCollection(String propertyName) {
        this.beanPropertyConfiguration.addCollection(propertyName);
        return this;
    }

    public MuleDefinitionParser addIgnored(String propertyName) {
        this.beanPropertyConfiguration.addIgnored(propertyName);
        return this;
    }

    public MuleDefinitionParser removeIgnored(String propertyName) {
        this.beanPropertyConfiguration.removeIgnored(propertyName);
        return this;
    }

    public MuleDefinitionParser setIgnoredDefault(boolean ignoreAll) {
        this.beanPropertyConfiguration.setIgnoredDefault(ignoreAll);
        return this;
    }

    protected void processProperty(Attr attribute, BeanAssembler assembler) {
        assembler.extendBean(attribute);
    }

    protected void postProcess(BeanAssembler assembler, Element element) {
        AutoIdUtils.ensureUniqueName(element, "bean");
        Iterator processes = this.postProcessors.iterator();
        while (processes.hasNext()) {
            ((PostProcessor)processes.next()).postProcess(assembler, element);
        }
    }

    protected void preProcess(Element element) {
        this.parserContext = null;
        this.registry = null;
        this.beanPropertyConfiguration.reset();
        Iterator processes = this.preProcessors.iterator();
        while (processes.hasNext()) {
            ((PreProcessor)processes.next()).preProcess(this.beanPropertyConfiguration, element);
        }
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        this.preProcess(element);
        this.setParserContext(parserContext);
        this.setRegistry(parserContext.getRegistry());
        this.checkElementNameUnique(element);
        Class beanClass = this.getClassInternal(element);
        BeanDefinitionBuilder builder = this.createBeanDefinitionBuilder(element, beanClass);
        builder.setSource(parserContext.extractSource((Object)element));
        builder.setSingleton(this.isSingleton());
        builder.addDependsOn("_muleRegistry");
        List interfaces = ClassUtils.getAllInterfaces((Class)beanClass);
        if (interfaces != null) {
            if (interfaces.contains(Initialisable.class)) {
                builder.setInitMethodName("initialise");
            }
            if (interfaces.contains(Disposable.class)) {
                builder.setDestroyMethodName("dispose");
            }
        }
        if (parserContext.isNested()) {
            builder.setSingleton(parserContext.getContainingBeanDefinition().isSingleton());
        }
        this.doParse(element, parserContext, builder);
        return builder.getBeanDefinition();
    }

    protected void setRegistry(BeanDefinitionRegistry registry) {
        this.registry = registry;
    }

    protected BeanDefinitionRegistry getRegistry() {
        if (null == this.registry) {
            throw new IllegalStateException("Set the registry from within doParse");
        }
        return this.registry;
    }

    protected void checkElementNameUnique(Element element) {
        if (null != element.getAttributeNode(ATTRIBUTE_NAME)) {
            String name = element.getAttribute(ATTRIBUTE_NAME);
            if (this.getRegistry().containsBeanDefinition(name)) {
                throw new IllegalArgumentException("A component named " + name + " already exists.");
            }
        }
    }

    protected BeanDefinitionBuilder createBeanDefinitionBuilder(Element element, Class beanClass) {
        return BeanDefinitionBuilder.rootBeanDefinition((Class)beanClass);
    }

    protected Class getClassInternal(Element element) {
        Class beanClass = null;
        if (this.isAllowClassAttribute()) {
            beanClass = this.getBeanClassFromAttribute(element);
        }
        if (beanClass == null) {
            beanClass = this.getBeanClass(element);
        }
        if (null != beanClass && null != this.classConstraint && !this.classConstraint.isAssignableFrom(beanClass)) {
            this.logger.error((Object)(beanClass + " not a subclass of " + this.classConstraint));
            beanClass = null;
        }
        if (null == beanClass) {
            throw new IllegalStateException("No class for element " + element.getNodeName());
        }
        return beanClass;
    }

    protected Class getBeanClassFromAttribute(Element element) {
        String className = element.getAttribute(ATTRIBUTE_CLASS);
        Class clazz = null;
        if (StringUtils.isNotBlank((String)className)) {
            try {
                element.removeAttribute(ATTRIBUTE_CLASS);
                clazz = ClassUtils.loadClass(className, this.getClass());
            }
            catch (ClassNotFoundException e) {
                this.logger.error((Object)("could not load class: " + className), (Throwable)e);
            }
        }
        return clazz;
    }

    protected abstract Class getBeanClass(Element var1);

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        BeanAssembler assembler = this.getBeanAssembler(element, builder);
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            this.processProperty(attribute, assembler);
        }
        this.postProcess(assembler, element);
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String name = element.getAttribute(ATTRIBUTE_NAME);
        if (org.springframework.util.StringUtils.hasText((String)name)) {
            return name;
        }
        return super.resolveId(element, definition, parserContext);
    }

    protected boolean isSingleton() {
        return this.singleton;
    }

    protected BeanAssembler getBeanAssembler(Element element, BeanDefinitionBuilder bean) {
        return this.getBeanAssemblerFactory().newBeanAssembler(this.beanPropertyConfiguration, bean, this.beanPropertyConfiguration, null);
    }

    protected boolean isAllowClassAttribute() {
        return this.allowClassAttribute;
    }

    protected void setAllowClassAttribute(boolean allowClassAttribute) {
        this.allowClassAttribute = allowClassAttribute;
    }

    protected Class getClassConstraint() {
        return this.classConstraint;
    }

    protected void setClassConstraint(Class classConstraint) {
        this.classConstraint = classConstraint;
    }

    protected ParserContext getParserContext() {
        return this.parserContext;
    }

    protected void setParserContext(ParserContext parserContext) {
        this.parserContext = parserContext;
    }

    protected boolean isTopLevel(Element element) {
        return element.getParentNode().getLocalName().equals(ROOT_ELEMENT) || element.getParentNode().getLocalName().equals(ROOT_UNSAFE_ELEMENT);
    }

    public AbstractBeanDefinition parseDelegate(Element element, ParserContext parserContext) {
        return this.parseInternal(element, parserContext);
    }

    public void registerPreProcessor(PreProcessor preProcessor) {
        this.preProcessors.addFirst(preProcessor);
    }

    public void registerPostProcessor(PostProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
    }

    public BeanAssemblerFactory getBeanAssemblerFactory() {
        return this.beanAssemblerFactory;
    }

    public void setBeanAssemblerFactory(BeanAssemblerFactory beanAssemblerFactory) {
        this.beanAssemblerFactory = beanAssemblerFactory;
    }
}

