/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import org.mule.config.spring.parsers.AbstractHierarchicalDefinitionParser;
import org.mule.config.spring.parsers.MuleChildDefinitionParser;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractChildDefinitionParser
extends AbstractHierarchicalDefinitionParser
implements MuleChildDefinitionParser {
    private static AtomicInteger idCounter = new AtomicInteger(0);

    protected final void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        this.setRegistry(parserContext.getRegistry());
        this.parseChild(element, parserContext, builder);
    }

    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setSingleton(this.isSingleton());
        super.doParse(element, parserContext, builder);
    }

    protected void postProcess(BeanAssembler assembler, Element element) {
        String name = this.generateChildBeanName(element);
        element.setAttribute("name", name);
        if (null != this.getPropertyName(element)) {
            assembler.insertBeanInTarget(this.getPropertyName(element));
        }
        super.postProcess(assembler, element);
    }

    protected String generateChildBeanName(Element e) {
        String parentId = this.getParentBeanName(e);
        String id = e.getAttribute("name");
        if (StringUtils.isBlank((String)id)) {
            if (!parentId.startsWith(".")) {
                parentId = "." + parentId;
            }
            return parentId + ":" + this.getBeanName(e);
        }
        return id;
    }

    protected String getBeanName(Element e) {
        return e.getLocalName() + "/" + idCounter.incrementAndGet();
    }

    public abstract String getPropertyName(Element var1);
}

