/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.util.Map;
import org.mule.MuleException;
import org.mule.config.spring.SpringRegistry;
import org.mule.registry.RegistrationException;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

public class StaticSpringRegistry
extends SpringRegistry {
    public static final String REGISTRY_ID = "org.mule.Registry.StaticSpring";
    public static final Integer OBJECT_SCOPE_SINGLETON = new Integer(1);
    public static final Integer OBJECT_SCOPE_PROTOTYPE = new Integer(2);
    public static final Integer OBJECT_SCOPE_POOLED = new Integer(3);
    protected StaticApplicationContext registryContext;

    public StaticSpringRegistry() {
        super(REGISTRY_ID, (ApplicationContext)null);
    }

    public StaticSpringRegistry(ApplicationContext applicationContext) {
        this(REGISTRY_ID, applicationContext);
    }

    public StaticSpringRegistry(String id) {
        this(id, (ApplicationContext)null);
    }

    public StaticSpringRegistry(String id, ApplicationContext applicationContext) {
        super(id);
        this.registryContext = applicationContext == null ? new StaticApplicationContext() : new StaticApplicationContext(applicationContext);
        this.registryContext.getBeanFactory().addBeanPostProcessor(new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if ((StaticSpringRegistry.this.isInitialised() || StaticSpringRegistry.this.isInitialising()) && bean instanceof Initialisable) {
                    try {
                        ((Initialisable)bean).initialise();
                    }
                    catch (InitialisationException e) {
                        throw new BeanCreationException("Failed to initialise Bean: " + e.getMessage(), (Throwable)e);
                    }
                }
                return bean;
            }
        });
        this.setApplicationContext((ApplicationContext)this.registryContext);
    }

    protected void registerSingleton(Object o) throws UMOException {
        try {
            Map m = BeanUtils.describe((Object)o);
            MutablePropertyValues mpvs = new MutablePropertyValues(m);
            this.registryContext.registerSingleton((String)m.get("name"), o.getClass(), mpvs);
        }
        catch (Exception e) {
            throw new MuleException(e);
        }
    }

    protected void registerPrototype(Object o) throws UMOException {
        try {
            Map m = BeanUtils.describe((Object)o);
            MutablePropertyValues mpvs = new MutablePropertyValues(m);
            this.registryContext.registerPrototype((String)m.get("name"), o.getClass(), mpvs);
        }
        catch (Exception e) {
            throw new MuleException(e);
        }
    }

    protected void doRegisterObject(String key, Object value, Object metadata, UMOManagementContext managementContext) throws RegistrationException {
        if (metadata instanceof Integer) {
            try {
                if (metadata.equals(OBJECT_SCOPE_SINGLETON)) {
                    this.registerSingleton(value);
                }
                if (metadata.equals(OBJECT_SCOPE_PROTOTYPE)) {
                    this.registerPrototype(value);
                }
                throw new RegistrationException("Object scope not recognized: " + metadata);
            }
            catch (UMOException e) {
                throw new RegistrationException(e);
            }
        } else {
            throw new RegistrationException("Object scope not recognized");
        }
    }

    public void registerConnector(UMOConnector connector, UMOManagementContext managementContext) throws UMOException {
        this.registerObject(connector.getName(), connector, OBJECT_SCOPE_SINGLETON, managementContext);
    }

    public UMOConnector unregisterConnector(String connectorName) throws UMOException {
        UMOConnector c = this.lookupConnector(connectorName);
        if (c != null) {
            c.dispose();
        }
        return c;
    }

    public void registerEndpoint(UMOImmutableEndpoint endpoint, UMOManagementContext managementContext) throws UMOException {
        this.registerObject(endpoint.getName(), endpoint, OBJECT_SCOPE_PROTOTYPE, managementContext);
    }

    public UMOImmutableEndpoint unregisterEndpoint(String endpointName) {
        UMOImmutableEndpoint ep = this.lookupEndpoint(endpointName);
        if (ep != null) {
            // empty if block
        }
        return ep;
    }

    public void registerTransformer(UMOTransformer transformer, UMOManagementContext managementContext) throws UMOException {
        this.registerObject(transformer.getName(), transformer, OBJECT_SCOPE_PROTOTYPE, managementContext);
    }

    public UMOTransformer unregisterTransformer(String transformerName) {
        UMOTransformer t = this.lookupTransformer(transformerName);
        if (t != null && t instanceof Disposable) {
            ((Disposable)((Object)t)).dispose();
        }
        return t;
    }

    public void registerModel(UMOModel model, UMOManagementContext managementContext) throws UMOException {
        this.registerObject(model.getName(), model, OBJECT_SCOPE_SINGLETON, managementContext);
    }

    public UMOModel unregisterModel(String name) {
        UMOModel model = this.lookupModel(name);
        if (model != null) {
            model.dispose();
        }
        return model;
    }

    public void registerAgent(UMOAgent agent, UMOManagementContext managementContext) throws UMOException {
        this.registerObject(agent.getName(), agent, OBJECT_SCOPE_SINGLETON, managementContext);
    }

    public UMOAgent unregisterAgent(String name) throws UMOException {
        UMOAgent agent = (UMOAgent)this.lookupObject(name);
        if (agent != null) {
            agent.dispose();
            agent.unregistered();
        }
        return agent;
    }

    public boolean isReadOnly() {
        return false;
    }
}

