/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.util.Collection;
import java.util.Properties;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.impl.container.MultiContainerContext;
import org.mule.impl.lifecycle.ContainerManagedLifecyclePhase;
import org.mule.impl.lifecycle.GenericLifecycleManager;
import org.mule.impl.registry.AbstractRegistry;
import org.mule.registry.ServiceDescriptor;
import org.mule.registry.ServiceDescriptorFactory;
import org.mule.registry.ServiceException;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.UMOLifecycleManager;
import org.mule.util.SpiUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringRegistry
extends AbstractRegistry
implements ApplicationContextAware {
    public static final String REGISTRY_ID = "org.mule.Registry.Spring";
    protected ApplicationContext applicationContext;
    protected MultiContainerContext containerContext;

    public SpringRegistry() {
        super(REGISTRY_ID);
    }

    public SpringRegistry(String id) {
        super(id);
    }

    public SpringRegistry(ApplicationContext applicationContext) {
        super(REGISTRY_ID);
        this.setApplicationContext(applicationContext);
    }

    public SpringRegistry(String id, ApplicationContext applicationContext) {
        super(id);
        this.setApplicationContext(applicationContext);
    }

    protected UMOLifecycleManager createLifecycleManager() {
        GenericLifecycleManager lcm = new GenericLifecycleManager();
        lcm.registerLifecycle(new ContainerManagedLifecyclePhase("initialise", Initialisable.class, "dispose"));
        lcm.registerLifecycle(new ContainerManagedLifecyclePhase("dispose", Disposable.class, "initialise"));
        return lcm;
    }

    protected Object doLookupObject(String key) {
        if (StringUtils.isBlank((String)key)) {
            this.logger.warn((Object)MessageFactory.createStaticMessage("Detected a lookup attempt with an empty or null key"), new Throwable().fillInStackTrace());
            return null;
        }
        try {
            return this.applicationContext.getBean(key);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.logger.debug((Object)e);
            return null;
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    protected Collection doLookupObjects(Class type) {
        return this.applicationContext.getBeansOfType(type).values();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ServiceDescriptor lookupServiceDescriptor(String type, String name, Properties overrides) throws ServiceException {
        Properties props = SpiUtils.findServiceDescriptor(type, name);
        if (props == null) {
            throw new ServiceException(CoreMessages.failedToLoad(type + " " + name));
        }
        return ServiceDescriptorFactory.create(type, name, props, overrides, this.applicationContext);
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isRemote() {
        return false;
    }
}

