/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.CoreXMLUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MuleHierarchicalBeanDefinitionParserDelegate
extends BeanDefinitionParserDelegate {
    public static final String BEANS = "beans";
    public static final String MULE_REPEAT_PARSE = "org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_REPEAT_PARSE";
    public static final String MULE_NO_RECURSE = "org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE";
    public static final String MULE_NO_REGISTRATION = "org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_REGISTRATION";
    public static final String MULE_POST_CHILDREN = "org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_POST_CHILDREN";
    private DefaultBeanDefinitionDocumentReader spring;
    protected static final Log logger = LogFactory.getLog((Class)MuleHierarchicalBeanDefinitionParserDelegate.class);

    public MuleHierarchicalBeanDefinitionParserDelegate(XmlReaderContext readerContext, DefaultBeanDefinitionDocumentReader spring) {
        super(readerContext);
        this.spring = spring;
    }

    public BeanDefinition parseCustomElement(Element element, BeanDefinition parent) {
        ParserContext parserContext;
        BeanDefinition finalChild;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parsing: " + CoreXMLUtils.elementToString(element)));
        }
        if (CoreXMLUtils.isBeansNamespace(element)) {
            return this.handleSpringElements(element, parent);
        }
        String namespaceUri = element.getNamespaceURI();
        NamespaceHandler handler = this.getReaderContext().getNamespaceHandlerResolver().resolve(namespaceUri);
        if (handler == null) {
            this.getReaderContext().error("Unable to locate NamespaceHandler for namespace [" + namespaceUri + "]", (Object)element);
            return null;
        }
        boolean isRecurse = false;
        do {
            parserContext = new ParserContext(this.getReaderContext(), (BeanDefinitionParserDelegate)this, parent);
            finalChild = handler.parse(element, parserContext);
            this.registerBean(element, finalChild);
            boolean bl = isRecurse = isRecurse || !MuleHierarchicalBeanDefinitionParserDelegate.testFlag(finalChild, MULE_NO_RECURSE);
        } while (null != finalChild && MuleHierarchicalBeanDefinitionParserDelegate.testFlag(finalChild, MULE_REPEAT_PARSE));
        if (CoreXMLUtils.isMuleNamespace(element) && isRecurse) {
            NodeList list = element.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (!(list.item(i) instanceof Element)) continue;
                this.parseCustomElement((Element)list.item(i), finalChild);
            }
        }
        if (MuleHierarchicalBeanDefinitionParserDelegate.testFlag(finalChild, MULE_POST_CHILDREN)) {
            parserContext = new ParserContext(this.getReaderContext(), (BeanDefinitionParserDelegate)this, parent);
            finalChild = handler.parse(element, parserContext);
        }
        return finalChild;
    }

    protected BeanDefinition handleSpringElements(Element element, BeanDefinition parent) {
        if (CoreXMLUtils.isLocalName(element, BEANS)) {
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                doc.appendChild(doc.importNode(element, true));
                this.spring.registerBeanDefinitions(doc, this.getReaderContext());
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        } else if (CoreXMLUtils.isLocalName(element, "property")) {
            this.parsePropertyElement(element, parent);
        } else if (CoreXMLUtils.isLocalName(element, "bean")) {
            this.registerBeanDefinitionHolder(this.parseBeanDefinitionElement(element, parent));
        } else {
            throw new IllegalStateException("Unexpected Spring element: " + CoreXMLUtils.elementToString(element));
        }
        return parent;
    }

    protected void registerBean(Element ele, BeanDefinition bd) {
        if (bd == null) {
            return;
        }
        if (!MuleHierarchicalBeanDefinitionParserDelegate.testFlag(bd, MULE_NO_REGISTRATION)) {
            String name = this.generateChildBeanName(ele);
            this.registerBeanDefinitionHolder(new BeanDefinitionHolder(bd, name));
        }
    }

    protected void registerBeanDefinitionHolder(BeanDefinitionHolder bdHolder) {
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)bdHolder, (BeanDefinitionRegistry)this.getReaderContext().getRegistry());
        this.getReaderContext().fireComponentRegistered((ComponentDefinition)new BeanComponentDefinition(bdHolder));
    }

    protected String generateChildBeanName(Element e) {
        String id = e.getAttribute("name");
        if (StringUtils.isBlank((String)id)) {
            String parentId = ((Element)e.getParentNode()).getAttribute("name");
            id = e.getLocalName();
            return "." + parentId + ":" + id;
        }
        return id;
    }

    public static void setFlag(BeanDefinition bean, String flag) {
        bean.setAttribute(flag, (Object)Boolean.TRUE);
    }

    public static boolean testFlag(BeanDefinition bean, String flag) {
        return null != bean && bean.hasAttribute(flag) && bean.getAttribute(flag) instanceof Boolean && (Boolean)bean.getAttribute(flag) != false;
    }
}

