/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.util.Iterator;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.impl.ManagementContext;
import org.mule.impl.internal.notifications.ServerNotificationManager;
import org.mule.registry.RegistrationException;
import org.mule.registry.Registry;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.lifecycle.UMOLifecycleManager;
import org.mule.umo.manager.UMOTransactionManagerFactory;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.umo.security.UMOSecurityManager;
import org.mule.util.ClassUtils;
import org.mule.util.queue.QueueManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ManagementContextFactoryBean
extends AbstractFactoryBean
implements ApplicationContextAware {
    public static final String LEGACY_MANAGER_PLACEHOLDER_CLASS = "org.mule.extras.spring.LegacyManagerPlaceholder";
    protected static Log logger = LogFactory.getLog((Class)ManagementContextFactoryBean.class);
    protected UMOManagementContext managementContext;
    protected Registry registry;
    private ApplicationContext context;
    private UMOLifecycleManager lifecycleManager;
    private ServerNotificationManager notificationManager;
    private UMOSecurityManager securityManager;
    private UMOWorkManager workManager;
    private TransactionManager transactionManager;
    private QueueManager queueManager;

    public ManagementContextFactoryBean(UMOLifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
    }

    protected Object createInstance() throws Exception {
        if (this.managementContext == null) {
            this.managementContext = new ManagementContext(this.lifecycleManager);
        }
        return this.managementContext;
    }

    public Class getObjectType() {
        return UMOManagementContext.class;
    }

    protected UMOManagementContext getManagementContext() {
        return this.managementContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        this.registry = RegistryContext.getRegistry();
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.init();
        this.managementContext.setNotificationManager(this.notificationManager);
        this.managementContext.setQueueManager(this.queueManager);
        this.managementContext.setSecurityManager(this.securityManager);
        this.managementContext.setWorkManager(this.workManager);
        this.managementContext.setTransactionManager(this.transactionManager);
        this.managementContext.initialise();
    }

    protected void destroyInstance(Object instance) throws Exception {
        this.managementContext.dispose();
        this.managementContext = null;
        this.registry = null;
    }

    protected void init() {
        try {
            Map temp = null;
            if (ClassUtils.isClassOnPath(LEGACY_MANAGER_PLACEHOLDER_CLASS, ((Object)((Object)this)).getClass())) {
                try {
                    Class clazz = ClassUtils.loadClass(LEGACY_MANAGER_PLACEHOLDER_CLASS, ((Object)((Object)this)).getClass());
                    temp = this.context.getBeansOfType(clazz);
                    if (temp.size() > 0) {
                        try {
                            this.setLegacyProperties((Map)this.context.getBean("_muleProperties", Map.class));
                        }
                        catch (BeansException beansException) {}
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if ((temp = this.context.getBeansOfType(UMOTransactionManagerFactory.class, true, false)).size() > 0) {
                this.transactionManager = ((UMOTransactionManagerFactory)temp.values().iterator().next()).create();
            } else {
                temp = this.context.getBeansOfType(TransactionManager.class, true, false);
                if (temp.size() > 0) {
                    this.transactionManager = (TransactionManager)temp.values().iterator().next();
                }
            }
            temp = this.context.getBeansOfType(UMOSecurityManager.class, true, false);
            if (temp.size() > 0) {
                this.securityManager = (UMOSecurityManager)temp.values().iterator().next();
            }
            if ((temp = this.context.getBeansOfType(ServerNotificationManager.class, true, false)).size() > 0) {
                this.notificationManager = (ServerNotificationManager)temp.values().iterator().next();
            }
            if ((temp = this.context.getBeansOfType(UMOWorkManager.class, true, false)).size() > 0) {
                this.workManager = (UMOWorkManager)temp.values().iterator().next();
            }
            if ((temp = this.context.getBeansOfType(QueueManager.class, true, false)).size() > 0) {
                this.queueManager = (QueueManager)temp.values().iterator().next();
            }
        }
        catch (Exception e) {
            throw new BeanInitializationException("Failed to wire MuleManager together: " + e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        super.destroy();
        if (this.managementContext != null) {
            this.managementContext.dispose();
        }
    }

    public void setManagerId(String managerId) {
        this.managementContext.setId(managerId);
    }

    protected void setLegacyProperties(Map props) {
        if (props != null) {
            try {
                Iterator iterator = props.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry e = iterator.next();
                    this.registry.registerObject((String)e.getKey(), e.getValue(), this.managementContext);
                }
            }
            catch (RegistrationException e) {
                logger.error((Object)e);
            }
        }
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
    }

    public ServerNotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public void setNotificationManager(ServerNotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(QueueManager queueManager) {
        this.queueManager = queueManager;
    }

    public UMOSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(UMOSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public UMOWorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(UMOWorkManager workManager) {
        this.workManager = workManager;
    }

    public UMOLifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public void setLifecycleManager(UMOLifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }
}

