/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mule.MuleRuntimeException;
import org.mule.RegistryContext;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.IOUtils;

public class FileUtils
extends org.apache.commons.io.FileUtils {
    public static final String DEFAULT_ENCODING = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void copyStreamToFile(InputStream input, File destination) throws IOException {
        if (destination.exists() && !destination.canWrite()) {
            throw new IOException("Destination file does not exist or is not writeable");
        }
        try {
            FileOutputStream output = new FileOutputStream(destination);
            try {
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public static File createFile(String filename) throws IOException {
        File file = FileUtils.newFile(filename);
        if (!file.canWrite()) {
            String dirName = file.getPath();
            int i = dirName.lastIndexOf(File.separator);
            if (i > -1) {
                dirName = dirName.substring(0, i);
                File dir = FileUtils.newFile(dirName);
                dir.mkdirs();
            }
            file.createNewFile();
        }
        return file;
    }

    public static String prepareWinFilename(String filename) {
        filename = filename.replaceAll("<", "(");
        filename = filename.replaceAll(">", ")");
        filename = filename.replaceAll("[/\\*?|:;\\]\\[\"]", "-");
        return filename;
    }

    public static File openDirectory(String directory) throws IOException {
        File dir = FileUtils.newFile(directory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory() || !dir.canRead()) {
            throw new IOException("Path: " + directory + " exists but isn't a directory");
        }
        return dir;
    }

    public static File stringToFile(String filename, String data) throws IOException {
        return FileUtils.stringToFile(filename, data, false);
    }

    public static synchronized File stringToFile(String filename, String data, boolean append) throws IOException {
        return FileUtils.stringToFile(filename, data, append, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized File stringToFile(String filename, String data, boolean append, boolean newLine) throws IOException {
        File f = FileUtils.createFile(filename);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(f, append));
            writer.write(data);
            if (newLine) {
                writer.newLine();
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return f;
    }

    public static String getResourcePath(String resourceName, Class callingClass) throws IOException {
        return FileUtils.getResourcePath(resourceName, callingClass, DEFAULT_ENCODING);
    }

    public static String getResourcePath(String resourceName, Class callingClass, String encoding) throws IOException {
        if (resourceName == null) {
            return null;
        }
        URL url = IOUtils.getResourceAsUrl(resourceName, callingClass);
        if (url == null) {
            return null;
        }
        return FileUtils.normalizeFilePath(url, encoding);
    }

    public static String normalizeFilePath(URL url, String encoding) throws UnsupportedEncodingException {
        String resource = URLDecoder.decode(url.toExternalForm(), encoding);
        if (resource != null) {
            if (resource.startsWith("file:/")) {
                resource = resource.substring(6);
            }
            if (!resource.startsWith(File.separator)) {
                resource = File.separator + resource;
            }
        }
        return resource;
    }

    public static boolean deleteTree(File dir) {
        if (dir == null || !dir.exists()) {
            return true;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!(files[i].isDirectory() ? !FileUtils.deleteTree(files[i]) : !files[i].delete())) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File archive, File directory) throws IOException {
        ZipFile zip = null;
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IOException("Directory is not a directory: " + directory);
            }
        } else if (!directory.mkdirs()) {
            throw new IOException("Could not create directory: " + directory);
        }
        try {
            zip = new ZipFile(archive);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File f = FileUtils.newFile(directory, entry.getName());
                if (entry.isDirectory()) {
                    if (f.mkdirs()) continue;
                    throw new IOException("Could not create directory: " + f);
                }
                InputStream is = zip.getInputStream(entry);
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
                IOUtils.copy((InputStream)is, (OutputStream)os);
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
    }

    public static File newFile(String pathName) {
        try {
            return new File(pathName).getCanonicalFile();
        }
        catch (IOException e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Unable to create a canonical file for " + pathName), (Throwable)e);
        }
    }

    public static File newFile(URI uri) {
        try {
            return new File(uri).getCanonicalFile();
        }
        catch (IOException e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Unable to create a canonical file for " + uri), (Throwable)e);
        }
    }

    public static File newFile(File parent, String child) {
        try {
            return new File(parent, child).getCanonicalFile();
        }
        catch (IOException e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Unable to create a canonical file for parent: " + parent + " and child: " + child), (Throwable)e);
        }
    }

    public static File newFile(String parent, String child) {
        try {
            return new File(parent, child).getCanonicalFile();
        }
        catch (IOException e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Unable to create a canonical file for parent: " + parent + " and child: " + child), (Throwable)e);
        }
    }

    public static void extractResources(String resourceName, Class callingClass, File outputDir, boolean keepParentDirectory) throws IOException {
        URL url = callingClass.getClassLoader().getResource(resourceName);
        URLConnection connection = url.openConnection();
        if (connection instanceof JarURLConnection) {
            FileUtils.extractJarResources((JarURLConnection)connection, outputDir, keepParentDirectory);
        } else {
            FileUtils.extractFileResources(FileUtils.normalizeFilePath(url, RegistryContext.getConfiguration().getDefaultEncoding()), outputDir, resourceName, keepParentDirectory);
        }
    }

    private static void extractFileResources(String path, File outputDir, String resourceName, boolean keepParentDirectory) throws IOException {
        File file = FileUtils.newFile(path);
        if (!file.exists()) {
            throw new IOException("The resource by path " + path + " ");
        }
        if (file.isDirectory()) {
            if (keepParentDirectory) {
                if (!(outputDir = FileUtils.newFile(outputDir.getPath() + File.separator + resourceName)).exists()) {
                    outputDir.mkdirs();
                }
            } else {
                outputDir = FileUtils.newFile(outputDir.getPath());
            }
            FileUtils.copyDirectory((File)file, (File)outputDir);
        } else {
            outputDir = keepParentDirectory ? FileUtils.newFile(outputDir.getPath() + File.separator + resourceName) : FileUtils.newFile(outputDir.getPath() + File.separator + file.getName());
            FileUtils.copyFile((File)file, (File)outputDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractJarResources(JarURLConnection connection, File outputDir, boolean keepParentDirectory) throws IOException {
        JarFile jarFile = connection.getJarFile();
        JarEntry jarResource = connection.getJarEntry();
        Enumeration<JarEntry> entries = jarFile.entries();
        InputStream inputStream = null;
        BufferedOutputStream outputStream = null;
        int jarResourceNameLenght = jarResource.getName().length();
        while (entries.hasMoreElements()) {
            File file;
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(jarResource.getName())) continue;
            String path = outputDir.getPath() + File.separator + entry.getName();
            if (!keepParentDirectory) {
                if (entry.isDirectory()) {
                    if (entry.getName().equals(jarResource.getName())) continue;
                    path = outputDir.getPath() + File.separator + entry.getName().substring(jarResourceNameLenght, entry.getName().length());
                } else {
                    path = entry.getName().length() > jarResourceNameLenght ? outputDir.getPath() + File.separator + entry.getName().substring(jarResourceNameLenght, entry.getName().length()) : outputDir.getPath() + File.separator + entry.getName().substring(entry.getName().lastIndexOf("/"), entry.getName().length());
                }
            }
            if (!(file = FileUtils.newFile(path)).getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException("Could not create directory: " + file.getParentFile());
            }
            if (entry.isDirectory()) {
                if (file.exists() || file.mkdirs()) continue;
                throw new IOException("Could not create directory: " + file);
            }
            try {
                inputStream = jarFile.getInputStream(entry);
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }
}

