/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import java.beans.ExceptionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCallback;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOTransaction;
import org.mule.umo.UMOTransactionConfig;

public class TransactionTemplate {
    private static final Log logger = LogFactory.getLog((Class)TransactionTemplate.class);
    private final UMOTransactionConfig config;
    private final ExceptionListener exceptionListener;
    private final UMOManagementContext context;

    public TransactionTemplate(UMOTransactionConfig config, ExceptionListener listener, UMOManagementContext context) {
        this.config = config;
        this.exceptionListener = listener;
        this.context = context;
    }

    public Object execute(TransactionCallback callback) throws Exception {
        if (this.config == null) {
            return callback.doInTransaction();
        }
        byte action = this.config.getAction();
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        if (action == 0 && tx != null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionAvailableButActionIs("None"));
        }
        if (action == 1 && tx != null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionAvailableButActionIs("Always Begin"));
        }
        if (action == 3 && tx == null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionNotAvailableButActionIs("Always Join"));
        }
        if (action == 1 || action == 2 && tx == null) {
            logger.debug((Object)"Beginning transaction");
            tx = this.config.getFactory().beginTransaction(this.context);
            logger.debug((Object)"Transaction successfully started");
        } else {
            tx = null;
        }
        try {
            Object result = callback.doInTransaction();
            if (tx != null) {
                if (tx.isRollbackOnly()) {
                    logger.debug((Object)"Transaction is marked for rollback");
                    tx.rollback();
                } else {
                    logger.debug((Object)"Committing transaction");
                    tx.commit();
                }
            }
            return result;
        }
        catch (Exception e) {
            if (this.exceptionListener != null) {
                logger.info((Object)("Exception Caught in Transaction template.  Handing off to exception handler: " + this.exceptionListener));
                this.exceptionListener.exceptionThrown(e);
            } else {
                logger.info((Object)"Exception Caught in Transaction template without any exception listeners defined, exception is rethrown.");
                if (tx != null) {
                    tx.setRollbackOnly();
                }
            }
            if (tx != null) {
                if (tx.isRollbackOnly()) {
                    logger.debug((Object)"Exception caught: rollback transaction", (Throwable)e);
                    tx.rollback();
                } else {
                    tx.commit();
                }
            }
            if (this.exceptionListener != null) {
                return null;
            }
            throw e;
        }
        catch (Error e) {
            if (tx != null) {
                logger.info((Object)"Error caught: rollback transaction", (Throwable)e);
                tx.rollback();
            }
            throw e;
        }
    }
}

