/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.providers;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.beans.ExceptionListener;
import org.mule.MuleException;
import org.mule.config.i18n.MessageFactory;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.model.seda.SedaModel;
import org.mule.providers.AbstractConnector;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.umo.UMOComponent;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageDispatcherFactory;

public abstract class AbstractConnectorTestCase
extends AbstractMuleTestCase {
    protected MuleDescriptor descriptor;
    protected UMOConnector connector;
    protected UMOModel model;
    private String connectorName = null;

    protected void doSetUp() throws Exception {
        this.model = new SedaModel();
        this.model.setName("default");
        managementContext.getRegistry().registerModel(this.model);
        this.descriptor = AbstractConnectorTestCase.getTestDescriptor("apple", Apple.class.getName());
        this.connector = this.getConnector();
        this.connectorName = this.connector.getName();
        if (this.connectorName == null) {
            AbstractConnectorTestCase.fail((String)"You need to set the connector name on the connector before returning it");
        }
        managementContext.getRegistry().registerConnector(this.connector);
        managementContext.start();
    }

    protected void doTearDown() throws Exception {
        if (!this.connector.isDisposed()) {
            this.connector.dispose();
        }
    }

    public void testConnectorExceptionHandling() throws Exception {
        AbstractConnectorTestCase.assertNotNull((Object)this.connector);
        Mock ehandlerMock = new Mock(ExceptionListener.class, "exceptionHandler");
        ehandlerMock.expect("exceptionThrown", (Object)C.isA((Class)Exception.class));
        AbstractConnectorTestCase.assertNotNull((Object)this.connector.getExceptionListener());
        this.connector.setExceptionListener((ExceptionListener)ehandlerMock.proxy());
        this.connector.handleException(new MuleException(MessageFactory.createStaticMessage("Dummy")));
        if (this.connector instanceof AbstractConnector) {
            ehandlerMock.expect("exceptionThrown", (Object)C.isA((Class)Exception.class));
            ((AbstractConnector)this.connector).exceptionThrown(new MuleException(MessageFactory.createStaticMessage("Dummy")));
        }
        ehandlerMock.verify();
        this.connector.setExceptionListener(null);
        try {
            this.connector.handleException(new MuleException(MessageFactory.createStaticMessage("Dummy")));
            AbstractConnectorTestCase.fail((String)"Should have thrown exception as no strategy is set");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testConnectorLifecycle() throws Exception {
        UMOConnector connector = managementContext.getRegistry().lookupConnector(this.connectorName);
        AbstractConnectorTestCase.assertNotNull((Object)connector);
        AbstractConnectorTestCase.assertTrue((boolean)connector.isStarted());
        AbstractConnectorTestCase.assertTrue((!connector.isDisposed() ? 1 : 0) != 0);
        connector.stop();
        AbstractConnectorTestCase.assertTrue((!connector.isStarted() ? 1 : 0) != 0);
        AbstractConnectorTestCase.assertTrue((!connector.isDisposed() ? 1 : 0) != 0);
        connector.dispose();
        AbstractConnectorTestCase.assertTrue((!connector.isStarted() ? 1 : 0) != 0);
        AbstractConnectorTestCase.assertTrue((boolean)connector.isDisposed());
        try {
            connector.start();
            AbstractConnectorTestCase.fail((String)"Connector cannot be restarted after being disposing");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testConnectorListenerSupport() throws Exception {
        AbstractConnectorTestCase.assertNotNull((Object)this.connector);
        MuleDescriptor d = AbstractConnectorTestCase.getTestDescriptor("anApple", Apple.class.getName());
        d.setModelName(this.model.getName());
        managementContext.getRegistry().registerService(d);
        UMOComponent component = this.model.getComponent(d.getName());
        UMOEndpoint endpoint = managementContext.getRegistry().createEndpointFromUri(new MuleEndpointURI(this.getTestEndpointURI()), "sender");
        try {
            this.connector.registerListener(null, null);
            AbstractConnectorTestCase.fail((String)"cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connector.registerListener(null, endpoint);
            AbstractConnectorTestCase.fail((String)"cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connector.registerListener(component, null);
            AbstractConnectorTestCase.fail((String)"cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.connector.registerListener(component, endpoint);
        this.connector.unregisterListener(component, endpoint);
        try {
            this.connector.unregisterListener(null, null);
            AbstractConnectorTestCase.fail((String)"cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connector.unregisterListener(component, null);
            AbstractConnectorTestCase.fail((String)"cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connector.unregisterListener(null, endpoint);
            AbstractConnectorTestCase.fail((String)"cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.connector.unregisterListener(component, endpoint);
        this.model.unregisterComponent(d);
    }

    public void testConnectorBeanProps() throws Exception {
        AbstractConnectorTestCase.assertNotNull((Object)this.connector);
        try {
            this.connector.setName(null);
            AbstractConnectorTestCase.fail((String)"Should throw IllegalArgumentException if name set to null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.connector.setName("Test");
        AbstractConnectorTestCase.assertEquals((String)"Test", (String)this.connector.getName());
        AbstractConnectorTestCase.assertNotNull((String)"Protocol must be set as a constant", (Object)this.connector.getProtocol());
    }

    public void testConnectorMessageAdapter() throws Exception {
        UMOConnector connector = managementContext.getRegistry().lookupConnector(this.connectorName);
        AbstractConnectorTestCase.assertNotNull((Object)connector);
        UMOMessageAdapter adapter = connector.getMessageAdapter(this.getValidMessage());
        AbstractConnectorTestCase.assertNotNull((Object)adapter);
    }

    public void testConnectorMessageDispatcherFactory() throws Exception {
        UMOConnector connector = managementContext.getRegistry().lookupConnector(this.connectorName);
        AbstractConnectorTestCase.assertNotNull((Object)connector);
        UMOMessageDispatcherFactory factory = connector.getDispatcherFactory();
        AbstractConnectorTestCase.assertNotNull((Object)factory);
    }

    public void testConnectorInitialise() throws Exception {
        UMOConnector connector = managementContext.getRegistry().lookupConnector(this.connectorName);
        try {
            connector.initialise();
            AbstractConnectorTestCase.fail((String)"A connector cannot be initialised more than once");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract UMOConnector getConnector() throws Exception;

    public abstract Object getValidMessage() throws Exception;

    public abstract String getTestEndpointURI();
}

