/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.impl.MuleDescriptor;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.model.UMOModel;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.FileUtils;
import org.mule.util.MuleUrlStreamHandlerFactory;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;
import org.mule.util.concurrent.Latch;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class AbstractMuleTestCase
extends TestCase {
    private static final boolean verbose;
    private boolean startContext = true;
    private boolean offline = System.getProperty("org.mule.offline", "false").equalsIgnoreCase("true");
    private static Map testCounters;
    protected static UMOManagementContext managementContext;
    public static final String TEST_MESSAGE = "Test Message";
    public static final long LOCK_TIMEOUT = 30000L;
    protected Latch callbackCalled;
    protected final transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public AbstractMuleTestCase() {
        if (testCounters == null) {
            testCounters = new HashMap();
        }
        this.addTest();
    }

    protected void addTest() {
        TestInfo info = (TestInfo)testCounters.get(((Object)((Object)this)).getClass().getName());
        if (info == null) {
            info = new TestInfo(((Object)((Object)this)).getClass().getName());
            testCounters.put(((Object)((Object)this)).getClass().getName(), info);
        }
        info.incTestCount();
    }

    protected void setDisposeManagerPerSuite(boolean val) {
        this.getTestInfo().setDisposeManagerPerSuite(val);
    }

    protected TestInfo getTestInfo() {
        TestInfo info = (TestInfo)testCounters.get(((Object)((Object)this)).getClass().getName());
        if (info == null) {
            info = new TestInfo(((Object)((Object)this)).getClass().getName());
            testCounters.put(((Object)((Object)this)).getClass().getName(), info);
        }
        return info;
    }

    private void clearAllCounters() {
        if (testCounters != null) {
            testCounters.clear();
        }
    }

    private void clearCounter() {
        if (testCounters != null) {
            testCounters.remove(((Object)((Object)this)).getClass().getName());
        }
    }

    public String getName() {
        if (verbose) {
            return super.getName().substring(4).replaceAll("([A-Z])", " $1").toLowerCase() + " ";
        }
        return super.getName();
    }

    public void run(TestResult result) {
        if (this.isDisabledInThisEnvironment()) {
            this.logger.info((Object)(((Object)((Object)this)).getClass().getName() + " disabled"));
            return;
        }
        super.run(result);
    }

    protected boolean isDisabledInThisEnvironment() {
        return false;
    }

    public void runBare() throws Throwable {
        if (this.isDisabledInThisEnvironment(super.getName())) {
            this.logger.warn((Object)(((Object)((Object)this)).getClass().getName() + "." + super.getName() + " disabled in this environment"));
            return;
        }
        super.runBare();
    }

    protected boolean isDisabledInThisEnvironment(String testMethodName) {
        return false;
    }

    public boolean isOffline(String method) {
        if (this.offline) {
            this.logger.warn((Object)StringMessageUtils.getBoilerPlate("Working offline cannot run test: " + method, '=', 80));
        }
        return this.offline;
    }

    protected final void setUp() throws Exception {
        if (verbose) {
            System.out.println(StringMessageUtils.getBoilerPlate("Testing: " + this.toString(), '=', 80));
        }
        try {
            if (this.getTestInfo().getRunCount() == 0) {
                if (this.getTestInfo().isDisposeManagerPerSuite()) {
                    this.disposeManager();
                }
                this.suitePreSetUp();
            }
            if (!this.getTestInfo().isDisposeManagerPerSuite()) {
                this.disposeManager();
            }
            managementContext = this.createManagementContext();
            if (this.startContext) {
                // empty if block
            }
            this.doSetUp();
            if (this.getTestInfo().getRunCount() == 0) {
                this.suitePostSetUp();
            }
        }
        catch (Exception e) {
            this.getTestInfo().incRunCount();
            throw e;
        }
    }

    protected UMOManagementContext createManagementContext() throws Exception {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("default-mule-config.xml");
        UMOManagementContext managementContext = (UMOManagementContext)ctx.getBean("_muleManagementContext");
        managementContext.getRegistry().registerModel(AbstractMuleTestCase.getDefaultModel(managementContext));
        return managementContext;
    }

    protected void suitePreSetUp() throws Exception {
    }

    protected void suitePostSetUp() throws Exception {
    }

    protected void suitePreTearDown() throws Exception {
    }

    protected void suitePostTearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void tearDown() throws Exception {
        try {
            if (this.getTestInfo().getRunCount() == this.getTestInfo().getTestCount()) {
                this.suitePreTearDown();
            }
            this.doTearDown();
            if (!this.getTestInfo().isDisposeManagerPerSuite()) {
                this.disposeManager();
            }
            Object var2_1 = null;
            this.getTestInfo().incRunCount();
            if (this.getTestInfo().getRunCount() != this.getTestInfo().getTestCount()) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.getTestInfo().incRunCount();
            if (this.getTestInfo().getRunCount() != this.getTestInfo().getTestCount()) throw throwable;
            try {
                this.suitePostTearDown();
                throw throwable;
            }
            finally {
                this.clearCounter();
                this.disposeManager();
            }
        }
        try {
            this.suitePostTearDown();
            return;
        }
        finally {
            this.clearCounter();
            this.disposeManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeManager() {
        try {
            if (managementContext != null && !managementContext.isDisposed() && !managementContext.isDisposing()) {
                if (RegistryContext.getRegistry() != null) {
                    FileUtils.deleteTree(FileUtils.newFile(RegistryContext.getConfiguration().getWorkingDirectory()));
                }
                managementContext.dispose();
            }
            FileUtils.deleteTree(FileUtils.newFile("./ActiveMQ"));
        }
        finally {
            managementContext = null;
        }
    }

    protected void doSetUp() throws Exception {
    }

    protected void doTearDown() throws Exception {
    }

    public static UMOModel getDefaultModel(UMOManagementContext context) throws UMOException {
        return MuleTestUtils.getDefaultModel(context);
    }

    public static UMOEndpoint getTestEndpoint(String name, String type) throws Exception {
        return MuleTestUtils.getTestEndpoint(name, type, managementContext);
    }

    public static UMOEvent getTestEvent(Object data) throws Exception {
        return MuleTestUtils.getTestEvent(data, managementContext);
    }

    public static UMOEventContext getTestEventContext(Object data) throws Exception {
        return MuleTestUtils.getTestEventContext(data, managementContext);
    }

    public static UMOTransformer getTestTransformer() {
        return MuleTestUtils.getTestTransformer();
    }

    public static UMOEvent getTestEvent(Object data, MuleDescriptor descriptor) throws Exception {
        return MuleTestUtils.getTestEvent(data, descriptor, managementContext);
    }

    public static UMOEvent getTestEvent(Object data, UMOImmutableEndpoint endpoint) throws Exception {
        return MuleTestUtils.getTestEvent(data, endpoint, managementContext);
    }

    public static UMOEvent getTestEvent(Object data, MuleDescriptor descriptor, UMOImmutableEndpoint endpoint) throws UMOException {
        return MuleTestUtils.getTestEvent(data, descriptor, endpoint);
    }

    public static UMOSession getTestSession(UMOComponent component) {
        return MuleTestUtils.getTestSession(component);
    }

    public static TestConnector getTestConnector() {
        return MuleTestUtils.getTestConnector();
    }

    public static UMOComponent getTestComponent(MuleDescriptor descriptor) {
        return MuleTestUtils.getTestComponent(descriptor);
    }

    public static MuleDescriptor getTestDescriptor() throws Exception {
        return AbstractMuleTestCase.getTestDescriptor("appleService", Apple.class.getName());
    }

    public static MuleDescriptor getTestDescriptor(String name, String implementation) throws Exception {
        return MuleTestUtils.getTestDescriptor(name, implementation, managementContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.clearAllCounters();
        }
        finally {
            super.finalize();
        }
    }

    protected boolean isStartContext() {
        return this.startContext;
    }

    protected void setStartContext(boolean startContext) {
        this.startContext = startContext;
    }

    static {
        String muleOpts = SystemUtils.getenv("MULE_TEST_OPTS");
        if (StringUtils.isNotBlank((String)muleOpts)) {
            Map parsedOpts = SystemUtils.parsePropertyDefinitions(muleOpts);
            String optVerbose = (String)parsedOpts.get("mule.verbose");
            verbose = Boolean.valueOf(optVerbose);
        } else {
            verbose = true;
        }
        MuleUrlStreamHandlerFactory.installUrlStreamHandlerFactory();
    }

    protected class TestInfo {
        private boolean disposeManagerPerSuite = false;
        private int testCount = 0;
        private int runCount = 0;
        private String name;

        public TestInfo(String name) {
            this.name = name;
        }

        public void clearCounts() {
            this.testCount = 0;
            this.runCount = 0;
        }

        public void incTestCount() {
            ++this.testCount;
        }

        public void incRunCount() {
            ++this.runCount;
        }

        public int getTestCount() {
            return this.testCount;
        }

        public int getRunCount() {
            return this.runCount;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDisposeManagerPerSuite() {
            return this.disposeManagerPerSuite;
        }

        public void setDisposeManagerPerSuite(boolean disposeManagerPerSuite) {
            this.disposeManagerPerSuite = disposeManagerPerSuite;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            return buf.append(this.name).append(", (").append(this.runCount).append(" / ").append(this.testCount).append(") tests run, disposePerSuite=").append(this.disposeManagerPerSuite).toString();
        }
    }
}

