/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import org.mule.impl.MuleEvent;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.routing.AggregationException;
import org.mule.routing.inbound.EventGroup;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;

public abstract class AbstractEventAggregator
extends SelectiveConsumer {
    public static final String NO_CORRELATION_ID = "no-id";
    private final ConcurrentMap eventGroups = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UMOEvent[] process(UMOEvent event) throws MessagingException {
        EventGroup group;
        UMOEvent[] result = null;
        if (!this.isMatch(event)) return result;
        boolean miss = false;
        Object groupId = this.getEventGroupIdForEvent(event);
        while (true) {
            if (miss) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if ((group = this.getEventGroup(groupId)) == null) {
                group = this.addEventGroup(this.createEventGroup(event, groupId));
            }
            EventGroup eventGroup = group;
            synchronized (eventGroup) {
                if (group == this.getEventGroup(groupId)) break;
                miss = true;
            }
        }
        {
            MuleEndpoint endpoint;
            group.addEvent(event);
            if (!this.shouldAggregateEvents(group)) return result;
            UMOMessage returnMessage = this.aggregateEvents(group);
            try {
                endpoint = new MuleEndpoint(event.getEndpoint());
            }
            catch (UMOException e) {
                throw new MessagingException(e.getI18nMessage(), returnMessage, (Throwable)e);
            }
            endpoint.setTransformer(null);
            endpoint.setName(this.getClass().getName());
            MuleEvent returnEvent = new MuleEvent(returnMessage, (UMOImmutableEndpoint)endpoint, event.getComponent(), event);
            result = new UMOEvent[]{returnEvent};
            this.removeEventGroup(group);
            return result;
        }
    }

    protected EventGroup createEventGroup(UMOEvent event, Object groupId) {
        return new EventGroup(groupId);
    }

    protected Object getEventGroupIdForEvent(UMOEvent event) {
        String groupId = event.getMessage().getCorrelationId();
        if (groupId == null) {
            groupId = NO_CORRELATION_ID;
        }
        return groupId;
    }

    protected EventGroup getEventGroup(Object groupId) {
        return (EventGroup)this.eventGroups.get(groupId);
    }

    protected EventGroup addEventGroup(EventGroup group) {
        EventGroup previous = (EventGroup)this.eventGroups.putIfAbsent(group.getGroupId(), (Object)group);
        return previous != null ? previous : group;
    }

    protected void removeEventGroup(EventGroup group) {
        this.eventGroups.remove(group.getGroupId());
    }

    protected abstract boolean shouldAggregateEvents(EventGroup var1);

    protected abstract UMOMessage aggregateEvents(EventGroup var1) throws AggregationException;
}

